<?php 

namespace PISOL\AWW\ADMIN;

use PISOL\AWW\CLASSES\Wallet_Manager;

if ( ! defined( 'WPINC' ) ) {
    die;
}

class Admin_Bootstrap {
    static $instance = null;
    
    /**
     * Schedule name for cashback expiry cron job
     */
    const CASHBACK_EXPIRY_CRON = 'pisol_aww_process_expired_cashbacks';

    public static function get_instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function __construct() {
        Menu::get_instance();
        CashBack_Option::get_instance();
        Recharge_Wallet_Option::get_instance();
        User_Profile::get_instance();
        View_Transactions::get_instance();
        Wallet_Refund::get_instance();
        Wallet_Refund_Option::get_instance();
        Review_Reward_Option::get_instance();
        Registration_Reward_Option::get_instance();
        Wallet_Coupon_Option::get_instance();
        CustomFields::get_instance();

        Wallet_Coupon::get_instance();

        new Review('WooCommerce Wallet and Cashback', 'advanced-wallet-for-woocommerce');
        // Initialize cron jobs
        $this->init_cron_jobs();
        
        // Hook into the cashback expiry cron event
        add_action(self::CASHBACK_EXPIRY_CRON, array($this, 'process_expired_cashbacks'));
        
        // Add JavaScript translation strings
        add_action('admin_enqueue_scripts', array($this, 'add_js_translations'));

        new Analytics(
            'WooCommerce Wallet & Cashback Plugin',
            'advanced-wallet-for-woocommerce/advanced-wallet-for-woocommerce.php',
            PISOL_AWW_VERSION
        );
    }
    
    /**
     * Initialize scheduled tasks
     */
    private function init_cron_jobs() {
        // Schedule the cashback expiry cron job if not already scheduled
        if (!wp_next_scheduled(self::CASHBACK_EXPIRY_CRON)) {
            wp_schedule_event(time(), 'daily', self::CASHBACK_EXPIRY_CRON);
        }
        
        // Add deactivation hook to clean up scheduled tasks
        register_deactivation_hook(PISOL_AWW_WOOCOMMERCE_PLUGIN_FILE, array($this, 'deactivate_scheduled_tasks'));
    }
    
    /**
     * Process expired cashback credits
     */
    public function process_expired_cashbacks() {
        // Only process if cashback expiry is enabled
        $expiry_days = absint(get_option('pisol_aww_cashback_expiry_days', 0));
        
        if ($expiry_days <= 0) {
            return;
        }
        
        // Process the expired cashbacks
        $wallet_manager = Wallet_Manager::get_instance();
        $result = $wallet_manager->process_expired_cashbacks('mark');
        
        // Log the result
        if (function_exists('pisol_aww_error_log')) {
            pisol_aww_error_log($result['message'], 'expired-cashbacks');
        }
    }
    
    /**
     * Clean up scheduled tasks on plugin deactivation
     */
    public function deactivate_scheduled_tasks() {
        $timestamp = wp_next_scheduled(self::CASHBACK_EXPIRY_CRON);
        if ($timestamp) {
            wp_unschedule_event($timestamp, self::CASHBACK_EXPIRY_CRON);
        }
    }
    
    /**
     * Add translation strings for JavaScript
     */
    public function add_js_translations() {
        wp_localize_script(PISOL_AWW_FOLDER_NAME . '-script', 'pisol_aww_i18n', array(
            'delete_transaction_confirm' => __('Are you sure you want to delete this transaction? This action will mark the transaction as deleted.', 'advanced-wallet-for-woocommerce'),
            'undelete_transaction_confirm' => __('Are you sure you want to restore this transaction? This will make the transaction active again.', 'advanced-wallet-for-woocommerce'),
            'deleting' => __('Deleting...', 'advanced-wallet-for-woocommerce'),
            'undeleting' => __('Restoring...', 'advanced-wallet-for-woocommerce'),
            'deleted' => __('Deleted', 'advanced-wallet-for-woocommerce'),
            'delete' => __('Delete', 'advanced-wallet-for-woocommerce'),
            'undelete' => __('Undelete', 'advanced-wallet-for-woocommerce'),
            'error_message' => __('An error occurred. Please try again.', 'advanced-wallet-for-woocommerce')
        ));
    }
}