<?php

// If uninstall not called from WordPress, exit
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

if ( ! current_user_can( 'delete_plugins' ) ) {
	exit;
}

// Don't delete any data if the PRO version is already active.
if ( class_exists( 'FBTWOOPro\\Init' ) ) {
	return;
}


$delete_data = get_option( 'fbtwoo_uninstall_remove_data' );
if ( ! $delete_data ) {
	return;
}

// Delete plugin options
delete_option( 'fbtwoo_position' );
delete_option( 'fbtwoo_title' );
delete_option( 'fbtwoo_total_text' );
delete_option( 'fbtwoo_button_text_no_product' );
delete_option( 'fbtwoo_button_text_one_product' );
delete_option( 'fbtwoo_button_text_two_product' );
delete_option( 'fbtwoo_button_text_three_product' );
delete_option( 'fbtwoo_button_color' );
delete_option( 'fbtwoo_button_color_hover' );
delete_option( 'fbtwoo_button_text_color' );
delete_option( 'fbtwoo_button_text_color_hover' );
delete_option( 'fbtwoo_save_text_color' );
delete_option( 'fbtwoo_uninstall_remove_data' );

// Get all products
$products = get_posts(array(
    'post_type'      => 'product',
    'numberposts'    => -1,
    'post_status'    => 'any',
));

// Loop through each product and delete metadata
foreach ($products as $product) {
    delete_post_meta($product->ID, '_fbtwoo_apply_discount');
    delete_post_meta($product->ID, '_fbtwoo_discount_type');
    delete_post_meta($product->ID, '_fbtwoo_discount_value');
    delete_post_meta($product->ID, '_fbtwoo_product_ids');
}