<div class="wrap">
<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
<?php
$tabs        = array(
	'tab-general'   => esc_html( __( 'General', 'frequently-bought-together-woo' ) ),
	'tab-content'   => esc_html( __( 'Content & Styles', 'frequently-bought-together-woo' ) ),
	'tab-extra'     => esc_html( __( 'Extra', 'frequently-bought-together-woo' ) ),
	'tab-shortcode' => esc_html( __( 'Shortcode', 'frequently-bought-together-woo' ) ),
);
$current_tab = isset( $_GET['tab'] ) && isset( $tabs[ $_GET['tab'] ] ) && isset( $_GET['nonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash($_GET['nonce'])), 'verify_fbtwoo_tab' ) ?  sanitize_text_field( wp_unslash($_GET['tab'])) : array_key_first( $tabs );
?>
<form method="post" action="options.php">
<nav class="nav-tab-wrapper">
	<?php
	foreach ( $tabs as $tab => $name ) {
		// CSS class for a current tab
		$current = $tab === $current_tab ? ' nav-tab-active' : '';
		// URL
		$url = add_query_arg(
			array(
				'page'  => 'fbtwoo-settings',
				'tab'   => $tab,
				'nonce' => wp_create_nonce( 'verify_fbtwoo_tab' ),
			),
			''
		);
		// printing the tab link
		echo '<a class="nav-tab' . esc_attr( $current ) . '" href="' . esc_url( $url ) . '">' . esc_html( $name ) . '</a>';
	}
	?>
</nav>

	<?php
	settings_fields( 'fbtwoo-settings-' . esc_attr( $current_tab ) );
	do_settings_sections( 'fbtwoo-settings-' . esc_attr( $current_tab ) );
	submit_button();
	?>
</form>
</div>
