<?php
defined( 'ABSPATH' ) || exit;
?>

<?php

global $product;
global $product_object;

if ( ( ! isset( $fbt_products ) || count( $fbt_products ) === 0 ) && ! $product ) {
	return;
}

$fbt_products = array_merge( array( $product ), $fbt_products );

$url = ! is_null( $product ) ? $product->get_permalink() : '';
$url = add_query_arg( 'action', 'fbtwoo_add_to_cart', $url );
$url = wp_nonce_url( $url, 'fbtwoo_add_to_cart' );
?>

<div id="fbtwoo-form-container" class="fbtwoo-form-container <?php echo esc_attr( $class ); ?>"  style="<?php echo esc_attr( $style ); ?>">
	<form class="fbtwoo-form" method="post" action="<?php echo esc_url( $url ); ?>">
		<?php
		if ( $title ) {
			echo '<div class="fbtwoo-form__title"><h3>' . esc_html( $title ) . '</h3></div>';
		}
		?>
		<div class="fbtwoo-form__main">
			<div class="fbtwoo-form__items">
				<?php
				$size               = apply_filters( 'fbtwoo_image_size', 'thumbnail' );
				$total              = 0;
				$fbt_products_count = count( $fbt_products );

				$button_classes = apply_filters( 'fbtwoo_button_add_to_cart_classes', array( 'button', 'btn', 'single_add_to_cart_button', 'alt', 'wp-element-button', 'fbtwoo-button' ) );

				if ( $fbt_products_count === 2 ) {
					$button_text = get_option( 'fbtwoo_button_text_two_product' );
				} elseif ( $fbt_products_count === 3 ) {
					$button_text = get_option( 'fbtwoo_button_text_three_product' );
				}

				$total_text = get_option( 'fbtwoo_total_text' );


				foreach ( $fbt_products as $index => $fbt_product ) {
					$id         = $fbt_product->get_id();
					$image      = $fbt_product->get_image( $size );
					$item_title = wp_trim_words( $fbt_product->get_name() );
					$price      = $fbt_product->get_price();
					$html_price = $fbt_product->get_price_html();

					$is_checked_by_default = $id;
					?>
						<div class="fbtwoo-form__item">
							<div class="fbtwoo-form__item-first-row">
								<div class="fbtwoo-form__item-image-container">
									<div class="fbtwoo-form__item-image">
										<?php
										echo wp_kses_post( $image );
										?>
									</div>
									<div class="fbtwoo-form__item-checkbox">
										<input type="checkbox" name="fbtwoo-products[]" value="<?php echo esc_attr( $id ); ?>" <?php checked( $is_checked_by_default, $id, true ); ?>  data-price="<?php echo esc_attr( $price ); ?>">
									</div>
								</div>
								<?php
								if ( $index < $fbt_products_count - 1 ) {
									?>
									<span class="fbtwoo-form__plus-symbol">+</span>
									<?php
								}
								?>
															</div>
							<div class="fbtwoo-form__item-title">
								<?php
								echo esc_html( $item_title );
								?>
							</div>
							<div class="fbtwoo-form__item-price">
								<?php
								echo wp_kses_post( $html_price );
								?>
							</div>
							
						</div>
					<?php

				}
				?>
				<input type="hidden" name="fbtwoo-parent-product" value="<?php echo esc_attr( $product->get_id() ); ?>">
			</div>
		
			
			<div class="fbtwoo-form__submit-area">
				<div class="fbtwoo-form__total-price-container">
					<div class="fbtwoo-form__total-price-label">
						<?php echo esc_html( $total_text ); ?>
					</div>
					<div class="fbtwoo-form__total-price">
					</div>
				</div>
				<div class="fbtwoo-form__add-to-cart">
					<button type="submit" class="<?php echo esc_attr( implode( ' ', $button_classes ) ); ?>"><?php echo esc_html( $button_text ); ?></button>
				</div>
			</div>
		</div>
	</form>
</div>
