<?php

namespace FBTWOO;

defined( 'ABSPATH' ) || exit;

use FBTWOO\Constants;

if ( ! class_exists( 'Settings' ) ) {
	class Settings {

		public function __construct() {
			add_action( 'admin_menu', array( $this, 'add_options_page' ) );
			add_action( 'admin_init', array( $this, 'register_settings' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_color_picker' ) );
		}

		function enqueue_color_picker( $hook_suffix ) {

			if ( 'settings_page_fbtwoo-settings' !== $hook_suffix ) {
				return;
			}

			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_script( 'fbtwoo-color-picker', Constants::$plugin_dir_url . 'assets/src/admin/js/color-picker.js', array( 'wp-color-picker' ), Constants::$plugin_version, true );

			if ( isset( $_GET['tab'] ) && $_GET['tab'] === 'tab-shortcode' && isset( $_GET['nonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash($_GET['nonce'])), 'verify_fbtwoo_tab' ) ) {
				wp_enqueue_script( 'hide-submit-button', Constants::$plugin_dir_url . 'assets/src/admin/js/hide-submit-button.js', array(), null, true );
			}
		}


		public function add_options_page() {
			add_options_page(
				__( 'Frequently Bought Toghether', 'frequently-bought-together-woo' ),
				__( 'Frequently Bought Toghether', 'frequently-bought-together-woo' ),
				'manage_options',
				'fbtwoo-settings',
				array( $this, 'render_settings_page' ),
			);
		}


		public function render_settings_page() {
			require_once Constants::$plugin_dir_path . 'templates/page-settings.php';
		}

		public function render_shortcode_page() {
			require_once Constants::$plugin_dir_path . 'templates/page-shortcode.php';
		}

		public function get_settings_section() {
			$settings_section = array(
				'fbtwoo-position-section'           => array(
					'title'    => __( 'Position', 'frequently-bought-together-woo' ),
					'callback' => array( $this, 'settings_section_callback' ),
					'tab'      => 'fbtwoo-settings-tab-general',
				),
				'fbtwoo-content-section'            => array(
					'title'    => __( 'Content', 'frequently-bought-together-woo' ),
					'callback' => array( $this, 'settings_section_callback' ),
					'tab'      => 'fbtwoo-settings-tab-content',
				),
				'fbtwoo-style-settings-section'     => array(
					'title'    => __( 'Style', 'frequently-bought-together-woo' ),
					'callback' => array( $this, 'style_settings_section_callback' ),
					'tab'      => 'fbtwoo-settings-tab-content',
				),
				'ri-wth-uninstall-settings-section' => array(
					'title'    => __( 'Data Deletion', 'frequently-bought-together-woo' ),
					'callback' => array( $this, 'uninstall_settings_section_callback' ),
					'tab'      => 'fbtwoo-settings-tab-extra',
				),
				'fbtwoo-shortcode-settings-section' => array(
					'title'    => __( 'Shortcode', 'frequently-bought-together-woo' ),
					'callback' => array( $this, 'shortcode_settings_section_callback' ),
					'tab'      => 'fbtwoo-settings-tab-shortcode',
				),
			);
			return $settings_section;
		}

		public static function get_position_options() {

			return apply_filters(
				'fbtwoo_position_options',
				array(
					'below_product_summary' => array(
						'hook_name' => 'woocommerce_product_meta_end',
						'label'     => __( 'Below Product Summary', 'frequently-bought-together-woo' ),
					),
					'below_product_tabs'    => array(
						'hook_name' => 'woocommerce_after_single_product_summary',
						'label'     => __( 'Below Product Tabs', 'frequently-bought-together-woo' ),
					),
					'above_product_tabs'    => array(
						'hook_name' => 'woocommerce_after_single_product_summary',
						'label'     => __( 'Above Product Tabs', 'frequently-bought-together-woo' ),
						'priority'  => 5,
					),
				)
			);
		}

		public function get_settings_field() {

			$settings_field = array(

				'fbtwoo_position'                  => array(
					'title'    => __( 'Box Position', 'frequently-bought-together-woo' ),
					'callback' => array( $this, 'select_callback' ),
					'tab'      => 'fbtwoo-settings-tab-general',
					'section'  => 'fbtwoo-position-section',
					'args'     => array(
						'type'    => 'select',
						'name'    => 'fbtwoo_position',
						'default' => 'above_product_tabs',
						'options' => $this->get_position_options(),
					),
				),

				'fbtwoo_title'                     => array(
					'title'    => __( 'Box Title', 'frequently-bought-together-woo' ),
					'callback' => array( $this, 'text_callback' ),
					'tab'      => 'fbtwoo-settings-tab-content',
					'section'  => 'fbtwoo-content-section',
					'args'     => array(
						'type' => 'text',
						'name' => 'fbtwoo_title',
					),
				),

				'fbtwoo_total_text'                => array(
					'title'    => __( 'Total Text', 'frequently-bought-together-woo' ),
					'callback' => array( $this, 'text_callback' ),
					'tab'      => 'fbtwoo-settings-tab-content',
					'section'  => 'fbtwoo-content-section',
					'args'     => array(
						'type' => 'text',
						'name' => 'fbtwoo_total_text',
					),
				),

				'fbtwoo_button_text_no_product'    => array(
					'title'    => __( 'Button Text Without Product selected', 'frequently-bought-together-woo' ),
					'callback' => array( $this, 'text_callback' ),
					'tab'      => 'fbtwoo-settings-tab-content',
					'section'  => 'fbtwoo-content-section',
					'args'     => array(
						'type' => 'text',
						'name' => 'fbtwoo_button_text_no_product',
					),
				),
				'fbtwoo_button_text_one_product'   => array(
					'title'    => __( 'Button Text With One Product selected', 'frequently-bought-together-woo' ),
					'callback' => array( $this, 'text_callback' ),
					'tab'      => 'fbtwoo-settings-tab-content',
					'section'  => 'fbtwoo-content-section',
					'args'     => array(
						'type' => 'text',
						'name' => 'fbtwoo_button_text_one_product',
					),
				),

				'fbtwoo_button_text_two_product'   => array(
					'title'    => __( 'Button Text With Two Product selected', 'frequently-bought-together-woo' ),
					'callback' => array( $this, 'text_callback' ),
					'tab'      => 'fbtwoo-settings-tab-content',
					'section'  => 'fbtwoo-content-section',
					'args'     => array(
						'type' => 'text',
						'name' => 'fbtwoo_button_text_two_product',
					),
				),

				'fbtwoo_button_text_three_product' => array(
					'title'    => __( 'Button Text With Three Product selected', 'frequently-bought-together-woo' ),
					'callback' => array( $this, 'text_callback' ),
					'tab'      => 'fbtwoo-settings-tab-content',
					'section'  => 'fbtwoo-content-section',
					'args'     => array(
						'type' => 'text',
						'name' => 'fbtwoo_button_text_three_product',
					),
				),

				'fbtwoo_button_color'              => array(
					'title'    => __( 'Button Color', 'frequently-bought-together-woo' ),
					'callback' => array( $this, 'color_callback' ),
					'tab'      => 'fbtwoo-settings-tab-content',
					'section'  => 'fbtwoo-style-settings-section',
					'args'     => array(
						'class'       => 'color',
						'option_name' => 'fbtwoo_button_color',
					),
				),

				'fbtwoo_button_color_hover'        => array(
					'title'    => __( 'Button Color on Hover', 'frequently-bought-together-woo' ),
					'callback' => array( $this, 'color_callback' ),
					'tab'      => 'fbtwoo-settings-tab-content',
					'section'  => 'fbtwoo-style-settings-section',
					'args'     => array(
						'class'       => 'color',
						'option_name' => 'fbtwoo_button_color_hover',
					),
				),

				'fbtwoo_button_text_color'         => array(
					'title'    => __( 'Button Text Color', 'frequently-bought-together-woo' ),
					'callback' => array( $this, 'color_callback' ),
					'tab'      => 'fbtwoo-settings-tab-content',
					'section'  => 'fbtwoo-style-settings-section',
					'args'     => array(
						'class'       => 'color',
						'option_name' => 'fbtwoo_button_text_color',
					),
				),

				'fbtwoo_button_text_color_hover'   => array(
					'title'    => __( 'Button Text Color on Hover', 'frequently-bought-together-woo' ),
					'callback' => array( $this, 'color_callback' ),
					'tab'      => 'fbtwoo-settings-tab-content',
					'section'  => 'fbtwoo-style-settings-section',
					'args'     => array(
						'class'       => 'color',
						'option_name' => 'fbtwoo_button_text_color_hover',
					),
				),

				'fbtwoo_save_text_color'           => array(
					'title'    => __( 'Save Text Color', 'frequently-bought-together-woo' ),
					'callback' => array( $this, 'color_callback' ),
					'tab'      => 'fbtwoo-settings-tab-content',
					'section'  => 'fbtwoo-style-settings-section',
					'args'     => array(
						'class'       => 'color',
						'option_name' => 'fbtwoo_save_text_color',
					),
				),

				'fbtwoo_uninstall_remove_data'     => array(
					'title'    => __( 'Delete data when removing plugin?', 'frequently-bought-together-woo' ),
					'callback' => array( $this, 'checkbox_callback' ),
					'tab'      => 'fbtwoo-settings-tab-extra',
					'section'  => 'ri-wth-uninstall-settings-section',
					'args'     => array(
						'type' => 'checkbox',
						'name' => 'fbtwoo_uninstall_remove_data',
					),
				),
			);

			return $settings_field;
		}


		public function register_settings() {

			$settings_section = $this->get_settings_section();
			$settings_field   = $this->get_settings_field();

			foreach ( $settings_section as $key => $value ) {

				add_settings_section(
					$key,
					esc_html( $value['title'] ),
					$value['callback'],
					$value['tab']
				);
			}

			foreach ( $settings_field as $key => $value ) {
				register_setting(
					$value['tab'],
					$key,
					array(
						'sanitize_callback' => array( $this, 'sanitize_settings' ),
					)
				);

				add_settings_field(
					$key,
					esc_html( $value['title'] ),
					$value['callback'],
					$value['tab'],
					$value['section'],
					isset( $value['args'] ) ? $value['args'] : ''
				);
			}
		}

		public function sanitize_settings( $input ) {

			if ( is_array( $input ) ) {
				return array_map( 'sanitize_text_field', $input ); // Sanitize each array value
			}

			// Handle different types of input
			if ( preg_match( '/^#[a-f0-9]{6}$/i', $input ) ) {
				return sanitize_hex_color( $input ); // HEX color
			}

			if ( in_array( $input, array( 'yes', 'no', '1', '0' ), true ) ) {
				return rest_sanitize_boolean( $input ); // Boolean values
			}

			return sanitize_text_field( $input ); // Default text sanitization
		}



		public function settings_section_callback() {
			echo '<p>' . esc_html__( 'Where do you want to show the box?', 'frequently-bought-together-woo' ) . '</p>';
		}


		public function checkbox_callback( $args ) {
			$option = get_option( $args['name'] );
			echo '<input type="checkbox" name="' . esc_attr( $args['name'] ) . '" value="1"' . checked( 1, $option, false ) . '>';
		}


		public function style_settings_section_callback() {
			esc_html_e( 'Add your style.', 'frequently-bought-together-woo' );
		}


		public function select_callback( $args ) {
			if ( ! isset( $args['options'] ) || empty( $args['options'] ) ) {
				return;
			}

			// Set a default value if not already stored in the database
			$default = isset( $args['default'] ) ? $args['default'] : '';
			$option  = get_option( $args['name'], $default ); // Use default value if option is not set
			$options = $args['options'];

			echo '<select name="' . esc_attr( $args['name'] ) . '">';
			foreach ( $options as $key => $o ) {
				echo '<option value="' . esc_attr( $key ) . '" ' . selected( $option, $key, false ) . '>' . esc_html( $o['label'] ) . '</option>';
			}
			echo '</select>';
			if ( isset( $args['description'] ) && ! empty( $args['description'] ) ) {
				echo '<p class=""description"">' . esc_html( $args['description'] ) . '</p>';
			}
		}

		public function text_callback( $args ) {
			$initial_settings = self::get_intial_settings();
			$initial_option   = isset( $initial_settings[ $args['name'] ] ) ? $initial_settings[ $args['name'] ] : '';
			$option           = get_option( $args['name'], $initial_option );
			echo '<input type="text" name="' . esc_attr( $args['name'] ) . '" value="' . esc_attr( $option ) . '">';
			if ( isset( $args['description'] ) && ! empty( $args['description'] ) ) {
				echo '<p class=""description"">' . esc_html( $args['description'] ) . '</p>';
			}
		}


		public function color_callback( $args ) {
			if ( ! isset( $args['option_name'] ) || ( isset( $args['option_name'] ) && $args['option_name'] == '' ) ) {
				return;
			}

			$option_name      = $args['option_name'];
			$option           = get_option( $option_name );
			$initial_settings = self::get_intial_settings();
			echo '<input type="text" id="' . esc_attr( $option_name ) . '" name="' . esc_attr( $option_name ) . '" value="' . esc_attr( $option ) . '" class="fbtwoo-color-field" data-default-color="' . esc_attr( $initial_settings[ $option_name ] ) . '" />';
		}


		public function uninstall_settings_section_callback() {
			echo esc_html( __( 'Deletes all data when plugin is removed.', 'frequently-bought-together-woo' ) );
		}

		public function shortcode_settings_section_callback() {
			?>
			<?php echo esc_html( __( 'Use this shortcode in your theme:', 'frequently-bought-together-woo' ) ); ?> <code>[fbtwoo_form]</code>
			<?php
		}


		public static function get_intial_settings() {
			$initial_settings = array(
				'fbtwoo_title'                     => __( 'Frequetly Bought Together', 'frequently-bought-together-woo' ),
				'fbtwoo_total_text'                => __( 'Total:', 'frequently-bought-together-woo' ),
				'fbtwoo_button_text_no_product'    => __( 'No Product Selected', 'frequently-bought-together-woo' ),
				'fbtwoo_button_text_one_product'   => __( 'Buy 1 Product', 'frequently-bought-together-woo' ),
				'fbtwoo_button_text_two_product'   => __( 'Buy 2 Products', 'frequently-bought-together-woo' ),
				'fbtwoo_button_text_three_product' => __( 'Buy 3 Products', 'frequently-bought-together-woo' ),
				'fbtwoo_button_color'              => '',
				'fbtwoo_button_color_hover'        => '',
				'fbtwoo_button_text_color'         => '',
				'fbtwoo_button_text_color_hover'   => '',
				'fbtwoo_save_text_color'           => '',
				'fbtwoo_uninstall_remove_data'     => 1,
			);
			return $initial_settings;
		}
	}
}
