<?php
/*
Plugin Name: RIACO Frequently Bought Together for WooCommerce
Description: Add Frequently Bought Together box in product page
Version: 1.0.0
Plugin URI:        https://www.robertoiacono.it/frequently-bought-together-woo/
Requires at least: 5.2
Requires PHP:      7.2
Author: Roberto Iacono
Author URI: https://www.robertoiacono.it/
License:           GPL v2 or later
License URI:       https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: frequently-bought-together-woo
Domain Path: /languages
Requires Plugins:  woocommerce
WC requires at least: 5.0
WC tested up to:  9.7
WC HPOS compatible: yes
*/

defined( 'ABSPATH' ) || exit;

if ( file_exists( plugin_dir_path( __FILE__ ) . 'vendor/autoload.php' ) ) {
	require_once plugin_dir_path( __FILE__ ) . 'vendor/autoload.php';
}

/**
 * Initialize all the core classes of the plugin
 */
if ( class_exists( 'FBTWOO\\Init' ) ) {
	new FBTWOO\Init();
}

// define compatibility with HPOS Woo
function riaco_frequently_bought_together_woo_hpos_compatibility() {

	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility(
			'custom_order_tables',
			__FILE__,
			true // true (compatible, default) or false (not compatible)
		);
	}
}
add_action( 'before_woocommerce_init', 'riaco_frequently_bought_together_woo_hpos_compatibility' );


register_activation_hook(__FILE__, 'fbtwoo_set_initial_settings');

function fbtwoo_set_initial_settings(){
	$default_settings = \FBTWOO\Settings::get_intial_settings();


	// Loop through each setting and update if it doesn't exist
    foreach ($default_settings as $key => $value) {
        if (get_option($key) === false) {  // Only set default if not already present
            update_option($key, $value);
        }
    }
}