jQuery(document).ready(function ($) {
  update_price();

  $(document).on("click", ".fbtwoo-form button", function (e) {
    // prevent error if shortcode is in place in other form with hidden required  fields
    $("select:hidden, textarea:hidden, input:hidden").attr("disabled", true);
    $("input[name='fbtwoo-parent-product']:hidden").attr("disabled", false);
    $(this).closest(".fbtwoo-form-").submit();
  });

  $(document).on(
    "change",
    ".fbtwoo-form input[name^='fbtwoo-products']",
    update_price
  );

  function update_price() {
    let $form = $(".fbtwoo-form input[name^='fbtwoo-products']").closest(
      ".fbtwoo-form"
    ); // Get the closest form
    let total = 0;
    let discount_total = 0;

    // Calculate total price
    $form.find("input[name^='fbtwoo-products']:checked").each(function () {
      let price = $(this).data("price") ? parseFloat($(this).data("price")) : 0;
      total += price;
    });

    discount_total = total; // Default: no discount

    const nProducts = $form.find("input[name^='fbtwoo-products']").length;
    const nChecked = $form.find(
      "input[name^='fbtwoo-products']:checked"
    ).length;

    // Apply discount logic
    if (
      fbtwoo_scripts.fbtwoo_apply_discount === "1" &&
      nChecked === nProducts
    ) {
      let discountType = fbtwoo_scripts.fbtwoo_discount_type;
      let discountValue = parseFloat(fbtwoo_scripts.fbtwoo_discount_value);

      if (discountValue > 0) {
        if (discountType === "percentage") {
          discount_total = total * (1 - discountValue / 100);
        } else if (discountType === "fixed") {
          discount_total = Math.max(0, total - discountValue); // Prevent negative prices
        }
      }
    }

    // Update the button text and state
    let $button = $form.find(".fbtwoo-form__add-to-cart button");

    if (nChecked === 0) {
      $button
        .text(fbtwoo_scripts.fbtwoo_button_text_no_product)
        .prop("disabled", true);
    } else {
      let newButtonValue =
        nChecked === 1
          ? fbtwoo_scripts.fbtwoo_button_text_one_product
          : nChecked === 2
          ? fbtwoo_scripts.fbtwoo_button_text_two_product
          : fbtwoo_scripts.fbtwoo_button_text_three_product;

      $button.text(newButtonValue).prop("disabled", false);
    }

    // Update price display
    let final_price;
    let final_output;

    final_output = '<div class="fbtwoo-form__total-price-label">Total:</div>';

    if (
      fbtwoo_scripts.fbtwoo_apply_discount === "1" &&
      total - discount_total > 0
    ) {
      final_price =
        '<div class="fbtwoo-form__total-price"><span class="fbtwoo-form__total-price--has-discount">' +
        formatPrice(total) +
        "</span> " +
        formatPrice(discount_total) +
        "</div>";
    } else {
      final_price = formatPrice(total);
    }

    final_output += final_price;
    const saved = total - discount_total;

    if (saved > 0) {
      save_price =
        '<div class="fbtwoo-form__total-price--saved-label">' +
        fbtwoo_scripts.fbtwoo_label_save +
        "</div>" +
        '<div class="fbtwoo-form__total-price--saved">' +
        formatPrice(saved) +
        "</div>";

      final_output += save_price;
    }

    $form.find(".fbtwoo-form__total-price-container").html(final_output);
  }

  // format price as Woocommerce options
  function formatPrice(price) {
    price = price.toFixed(fbtwoo_scripts.decimals);
    if (fbtwoo_scripts.decimals) {
      if (fbtwoo_scripts.decimal_separator === ",") {
        price = price.replace(".", fbtwoo_scripts.decimal_separator);
      } else if (fbtwoo_scripts.decimal_separator === ".") {
        price = price.replace(",", fbtwoo_scripts.decimal_separator);
      }
    }
    if (fbtwoo_scripts.thousand_separator) {
      price = price
        .toString()
        .replace(/\B(?=(\d{3})+(?!\d))/g, fbtwoo_scripts.thousand_separator);
    }
    let format = fbtwoo_scripts.price_format; //"%2$s %1$s"

    let formattedPrice =
      '<span class="woocommerce-Price-amount amount"><bdi>' +
      format +
      "</bdi></span>";

    formattedPrice = formattedPrice.replace(
      "%1$s",
      '<span class="woocommerce-Price-currencySymbol">' +
        fbtwoo_scripts.currencySymbol +
        "</span>"
    );

    formattedPrice = formattedPrice.replace("%2$s", price);

    return formattedPrice;
  }
});
