jQuery(document).ready(function ($) {
  var currencySymbol = fbtwoo_discount_manager_scripts.currencySymbol;

  function toggleDiscountFields() {
    if ($("#fbtwoo_apply_discount").is(":checked")) {
      $(".fbtwoo_discount_type_field, .fbtwoo_discount_value_field").show();
    } else {
      $(".fbtwoo_discount_type_field, .fbtwoo_discount_value_field").hide();
    }
  }

  function updateDiscountLabel() {
    var selectedType = $("#fbtwoo_discount_type").val();
    $("#fbtwoo_discount_label").text(
      selectedType === "percentage" ? "%" : currencySymbol
    );
  }

  $("#fbtwoo_apply_discount").on("change", toggleDiscountFields);
  $("#fbtwoo_discount_type").on("change", updateDiscountLabel);

  // Initial State
  toggleDiscountFields();
  updateDiscountLabel();
});
