jQuery(function ($) {
  $("#fbtwoo_product_ids").select2({
    ajax: {
      url: fbtwoo_ajax.ajax_url,
      dataType: "json",
      delay: 250,
      data: function (params) {
        return {
          action: "fbtwoo_custom_product_search", // Use our custom AJAX action
          term: params.term,
          security: fbtwoo_ajax.security,
        };
      },
      processResults: function (data) {
        if (data.success) {
          return { results: data.data };
        } else {
          return { results: [] };
        }
      },
      cache: true,
    },
    minimumInputLength: 2,
  });
});
