<?php

namespace PISOL\ANFW\FRONT;

class Outof_Stock_Trigger {

    static $instance = null;

    static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action('woocommerce_no_stock_notification', array(__CLASS__, 'on_no_stock_notification'), 10);
    }

    public static function on_no_stock_notification($product) {
        // Fire your trigger here. For now, just a placeholder action.
        self::trigger($product);   
    }

    /**
     * Trigger the low stock notification.
     *
     * @param WC_Product $product The product that is low in stock.
     */
    public static function trigger($product) {
       Run_Notification::run_notifications('out_of_stock', array(
            'product' => $product,
        ));
    }
}