<?php

namespace PISOL\ANFW\FRONT;

class NewOrder_Trigger {

    static $instance = null;

    static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action('woocommerce_order_status_changed', array(__CLASS__, 'on_order_status_changed'), 10, 4);
    }

    public static function on_order_status_changed($order_id, $from_status, $to_status, $order) {

        $valid_transitions = self::get_state_changes();

        if (empty($valid_transitions)) {
            return; // No valid transitions defined
        }

        foreach ($valid_transitions as $transition) {
            if ($from_status === $transition['from'] && $to_status === $transition['to']) {
                // Fire your trigger here. For now, just a placeholder action.
                self::trigger($order_id, $from_status, $to_status, $order);
                break;
            }
        }
    }

    public static function trigger($order_id, $from_status, $to_status, $order) {
       Run_Notification::run_notifications('new_order', array(
            'order_id' => $order_id,
            'from_status' => $from_status,
            'to_status' => $to_status,
            'order' => $order
        ));
    }

    static function get_state_changes(){
        $options = get_option('pi_anfw_new_order_trigger_order_status', ['pending-processing', 'pending-completed', 'failed-processing', 'failed-completed']);

        if(empty($options) || !is_array($options)){
            $options = ['pending-processing', 'pending-completed', 'failed-processing', 'failed-completed'];
        }

        $valid_transitions = array();
        foreach ($options as $option) {
            if (strpos($option, '|') !== false) {
                list($from, $to) = explode('|', $option);
                $valid_transitions[] = array('from' => $from, 'to' => $to);
            }
        }
        return $valid_transitions;
    }

}