<?php
namespace PISOL\ANFW\FRONT;

defined('ABSPATH') || exit;

/**
 * Bootstrap for frontend functionality
 */
class Front_Bootstrap {
    
    /**
     * The single instance of this class
     *
     * @var Front_Bootstrap
     */
    private static $instance = null;

    /**
     * Main instance
     * 
     * Ensures only one instance is loaded or can be loaded.
     *
     * @return Front_Bootstrap
     */
    public static function get_instance() {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Constructor
     */
    public function __construct() {
        $this->load_dependencies();
    }

    /**
     * Load dependencies
     */
    private function load_dependencies() {
        // Load frontend classes
        NewOrder_Trigger::get_instance();   
        Low_Stock_Trigger::get_instance();
        Outof_Stock_Trigger::get_instance();
        BackOrder_Trigger::get_instance();
    }
}