<?php

namespace PISOL\ANFW\FRONT;

class BackOrder_Trigger {

    static $instance = null;

    static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action('woocommerce_product_on_backorder_notification', array(__CLASS__, 'on_backorder_notification'), 10);
    }

    public static function on_backorder_notification($arg) {
        // Fire your trigger here. For now, just a placeholder action.
        self::trigger($arg);   
    }

    /**
     * Trigger the low stock notification.
     *
     * @param WC_Product $product The product that is low in stock.
     */
    public static function trigger($arg) {
       Run_Notification::run_notifications('backorder', array(
            'product' => $arg['product'],
            'quantity' => $arg['quantity'],
            'order_id' => $arg['order_id'],
        ));
    }
}