<?php
/**
 * Abstract class for Notification Types
 *
 * This class will be extended to create specific notification types like Email, Telegram, WhatsApp, etc.
 */

abstract class Notification_Type {
    /**
     * Send the notification.
     *
     * @param array $data Data required to send the notification.
     * @return bool True on success, false on failure.
     */
    abstract public function send(array $data): bool;

    /**
     * Get the name of the notification type.
     *
     * @return string
     */
    abstract public function get_name(): string;

    /**
     * Get a description of the notification type.
     *
     * @return string
     */
    public function get_description(): string {
        return '';
    }
}
