<?php
/*
 * Plugin Name:       Advance notification for WooCommerce
 * Plugin URI:        https://www.piwebsolution.com/
 * Description:       Send notifications to customers when order is received, stock is log, out of stock, backorder, refund is issued
 * Version:           1.0.10
 * Author URI:        https://www.piwebsolution.com/shop
 * Author:            PI Websolution
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       advance-notification-for-woocommerce
 * Requires Plugins: woocommerce
 * WC tested up to: 10.4.3
*/

if ( ! defined( 'WPINC' ) ) {
    die;
}

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

if(!is_plugin_active( 'woocommerce/woocommerce.php')){
    add_action( 'admin_notices', function () {
        ?>
        <div class="error notice">
            <p><?php esc_html_e( '⚠️ Please Install and Activate WooCommerce plugin, without that this plugin cant work', 'advance-notification-for-woocommerce' ); ?></p>
        </div>
        <?php
    } );
    return;
}

if(!function_exists('pisol_anfw_error_log')){
    function pisol_anfw_error_log($message, $context = 'custom') {
        if (class_exists('WC_Logger')) {
            $logger = wc_get_logger();
            $logger->error(is_string($message) ? $message : wp_json_encode($message), array('source' => 'Order tag assignment', 'context' => $context));
        }
    }
}

add_action( 'plugin_action_links_' . plugin_basename( __FILE__ ),  function ( $links ) {
    $links = array_merge( array(
        '<a href="' . esc_url( admin_url( '/admin.php?page=advance-notification-for-woocommerce' ) ) . '">' . esc_html__( 'Settings', 'advance-notification-for-woocommerce' ) . '</a>',
        '<a style="color:#0a9a3e; font-weight:bold;" target="_blank" href="'.esc_url(admin_url('/edit.php?post_type=pisol_anfw_notice')).'">' . esc_html__( 'Notification','advance-notification-for-woocommerce' ) . '</a>'
    ), $links );
    return $links;
} );



/**
 * Declare compatible with HPOS new order table 
 */
add_action( 'before_woocommerce_init', function() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
} );

define( 'PISOL_ANFW_VERSION', '1.0.10' );
define( 'PISOL_ANFW_FOLDER_URL', plugin_dir_url( __FILE__ ));
define( 'PISOL_ANFW_FOLDER_PATH', plugin_dir_path( __FILE__ ));
define( 'PISOL_ANFW_FOLDER_NAME',  dirname( plugin_basename( __FILE__ ) ));
define( 'PISOL_ANFW_PLUGIN_NAME',  'advance-notification-for-woocommerce');

define( 'PISOL_ANFW_WOOCOMMERCE_PLUGIN_FOLDER', plugin_basename( __DIR__ ) );
define( 'PISOL_ANFW_WOOCOMMERCE_PLUGIN_PATH', plugin_basename( __FILE__ ) );
define( 'PISOL_ANFW_WOOCOMMERCE_PLUGIN_FILE',  __FILE__  );

require plugin_dir_path( __FILE__ ) . 'autoloader.php';
require plugin_dir_path( __FILE__ ) . 'class-main.php';

PISOL_ANFW_Main::get_instance();







