<?php
/**
 * Template for tag conditions form
 *
 * @package Auto_Assign_Order_Tags_For_WooCommerce
 */

defined('ABSPATH') || exit;
?>

<div class="pisol-anfw-conditions-container">
    <p class="description">
        <?php esc_html_e('Add condition groups to trigger this notification', 'advance-notification-for-woocommerce'); ?>
    </p>

    <div id="pisol-anfw-groups-list">
        <?php
        if (!empty($conditions)) :
            $first_group = true;
            foreach ($conditions as $group_id => $group) : 
                $match_type = isset($group['match_type']) ? $group['match_type'] : 'all';
                $group_logic = isset($group['logic']) ? $group['logic'] : 'AND';
                $group_conditions = isset($group['conditions']) ? $group['conditions'] : array();
                ?>
                
                <?php if (!$first_group) : ?>
                <div class="pisol-anfw-group-logic-divider">
                    <select name="pisol_anfw_conditions[<?php echo esc_attr($group_id); ?>][logic]" class="pisol-anfw-group-logic">
                        <option value="AND" <?php selected($group_logic, 'AND'); ?>><?php esc_html_e('AND', 'advance-notification-for-woocommerce'); ?></option>
                        <option value="OR" <?php selected($group_logic, 'OR'); ?>><?php esc_html_e('OR', 'advance-notification-for-woocommerce'); ?></option>
                    </select>
                </div>
                <?php endif; ?>

                <div class="pisol-anfw-group" data-group-id="<?php echo esc_attr($group_id); ?>">
                    <div class="pisol-anfw-group-header">
                        <div class="pisol-anfw-group-title">
                            <?php esc_html_e('Condition Group', 'advance-notification-for-woocommerce'); ?>
                        </div>
                        <div class="pisol-anfw-group-match-type">
                            <select name="pisol_anfw_conditions[<?php echo esc_attr($group_id); ?>][match_type]" class="pisol-anfw-match-type">
                                <option value="all" <?php selected($match_type, 'all'); ?>><?php esc_html_e('All conditions match', 'advance-notification-for-woocommerce'); ?></option>
                                <option value="any" <?php selected($match_type, 'any'); ?>><?php esc_html_e('Any condition matches', 'advance-notification-for-woocommerce'); ?></option>
                            </select>
                        </div>
                        <div class="pisol-anfw-group-actions">
                            <button type="button" class="button pisol-anfw-add-condition-to-group"><?php esc_html_e('Add Condition', 'advance-notification-for-woocommerce'); ?></button>
                            <button type="button" class="button pisol-anfw-remove-group"><?php esc_html_e('Remove Group', 'advance-notification-for-woocommerce'); ?></button>
                        </div>
                    </div>

                    <div class="pisol-anfw-group-content">
                        <div class="pisol-anfw-conditions-list">
                            <?php
                            if (!empty($group_conditions)) :
                                foreach ($group_conditions as $condition_id => $condition) : 
                                    $type = isset($condition['type']) ? $condition['type'] : '';
                                    $operator = isset($condition['operator']) ? $condition['operator'] : '';
                                    $value = isset($condition['value']) ? $condition['value'] : '';
                                    ?>

                                    <div class="pisol-anfw-condition" data-condition-id="<?php echo esc_attr($condition_id); ?>">
                                        <div class="pisol-anfw-condition-content">
                                            <select name="pisol_anfw_conditions[<?php echo esc_attr($group_id); ?>][conditions][<?php echo esc_attr($condition_id); ?>][type]" class="pisol-anfw-condition-type">
                                                <option value=""><?php esc_html_e('Select Condition', 'advance-notification-for-woocommerce'); ?></option>
                                                <?php foreach ($condition_types as $group_name => $group_conditions) : 
                                                    if (is_array($group_conditions)) : ?>
                                                        <optgroup label="<?php echo esc_attr($group_name); ?>">
                                                            <?php foreach ($group_conditions as $condition_key => $condition_label) : ?>
                                                                <option value="<?php echo esc_attr($condition_key); ?>" <?php selected($type, $condition_key); ?>><?php echo esc_html($condition_label); ?></option>
                                                            <?php endforeach; ?>
                                                        </optgroup>
                                                    <?php else : ?>
                                                        <option value="<?php echo esc_attr($group_name); ?>" <?php selected($type, $group_name); ?>><?php echo esc_html($group_conditions); ?></option>
                                                    <?php endif; ?>
                                                <?php endforeach; ?>
                                            </select>

                                            <div class="pisol-anfw-condition-data" 
                                                data-condition-type="<?php echo esc_attr($type); ?>"
                                                data-condition-operator="<?php echo esc_attr($operator); ?>"
                                                data-condition-value="<?php echo is_array($value) ? esc_attr(wp_json_encode($value)) : esc_attr($value); ?>">
                                            </div>

                                            <div class="pisol-anfw-condition-details" style="<?php echo empty($type) ? 'display:none;' : ''; ?>">
                                                <div class="pisol-anfw-operator-container">
                                                    <?php if (!empty($type)) : ?>
                                                        <?php 
                                                        $operators = apply_filters("pisol_anfw_{$type}_operators", array(), $selected_trigger);
                                                        if (!empty($operators)) : 
                                                        ?>
                                                        <select name="pisol_anfw_conditions[<?php echo esc_attr($group_id); ?>][conditions][<?php echo esc_attr($condition_id); ?>][operator]" class="pisol-anfw-operator">
                                                            <?php foreach ($operators as $op_key => $op_label) : ?>
                                                                <option value="<?php echo esc_attr($op_key); ?>" <?php selected($operator, $op_key); ?>><?php echo esc_html($op_label); ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </div>

                                                <div class="pisol-anfw-value-container">
                                                    <?php if (!empty($type)) : ?>
                                                        <?php 
                                                        // Apply filter to get value field HTML for this condition type
                                                        $value_field = apply_filters("pisol_anfw_{$type}_value_field", '', $group_id . '_' . $condition_id, '', $value);
                                                        
                                                        // Escape the HTML content using wp_kses with the allowed HTML from the Order_Tags class
                                                        echo wp_kses($value_field, self::get_allowed_html());
                                                        ?>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                            <button type="button" class="button pisol-anfw-remove-condition"><?php esc_html_e('Remove', 'advance-notification-for-woocommerce'); ?></button>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php $first_group = false; ?>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <div class="pisol-anfw-actions">
        <button type="button" class="button button-primary pisol-anfw-add-group"><?php esc_html_e('Add Condition Group', 'advance-notification-for-woocommerce'); ?></button>
    </div>
    
    <!-- Templates for JavaScript -->
    <script type="text/template" id="tmpl-pisol-anfw-group">
        <div class="pisol-anfw-group" data-group-id="{{ data.groupId }}">
            <div class="pisol-anfw-group-header">
                <div class="pisol-anfw-group-title">
                    <?php esc_html_e('Condition Group', 'advance-notification-for-woocommerce'); ?>
                </div>
                <div class="pisol-anfw-group-match-type">
                    <select name="pisol_anfw_conditions[{{ data.groupId }}][match_type]" class="pisol-anfw-match-type">
                        <option value="all"><?php esc_html_e('All conditions match', 'advance-notification-for-woocommerce'); ?></option>
                        <option value="any"><?php esc_html_e('Any condition matches', 'advance-notification-for-woocommerce'); ?></option>
                    </select>
                </div>
                <div class="pisol-anfw-group-actions">
                    <button type="button" class="button pisol-anfw-add-condition-to-group"><?php esc_html_e('Add Condition', 'advance-notification-for-woocommerce'); ?></button>
                    <button type="button" class="button pisol-anfw-remove-group"><?php esc_html_e('Remove Group', 'advance-notification-for-woocommerce'); ?></button>
                </div>
            </div>
            <div class="pisol-anfw-group-content">
                <div class="pisol-anfw-conditions-list"></div>
            </div>
        </div>
    </script>

    <script type="text/template" id="tmpl-pisol-anfw-group-logic-divider">
        <div class="pisol-anfw-group-logic-divider">
            <select name="pisol_anfw_conditions[{{ data.groupId }}][logic]" class="pisol-anfw-group-logic">
                <option value="AND"><?php esc_html_e('AND', 'advance-notification-for-woocommerce'); ?></option>
                <option value="OR"><?php esc_html_e('OR', 'advance-notification-for-woocommerce'); ?></option>
            </select>
        </div>
    </script>

    <script type="text/template" id="tmpl-pisol-anfw-condition">
        <div class="pisol-anfw-condition" data-condition-id="{{ data.conditionId }}">
            <div class="pisol-anfw-condition-content">
                <select name="pisol_anfw_conditions[{{ data.groupId }}][conditions][{{ data.conditionId }}][type]" class="pisol-anfw-condition-type">
                    <option value=""><?php esc_html_e('Select Condition', 'advance-notification-for-woocommerce'); ?></option>
                    <?php foreach ($condition_types as $group_name => $group_conditions) : 
                        if (is_array($group_conditions)) : ?>
                            <optgroup label="<?php echo esc_attr($group_name); ?>">
                                <?php foreach ($group_conditions as $condition_key => $condition_label) : ?>
                                    <option value="<?php echo esc_attr($condition_key); ?>"><?php echo esc_html($condition_label); ?></option>
                                <?php endforeach; ?>
                            </optgroup>
                        <?php else : ?>
                            <option value="<?php echo esc_attr($group_name); ?>"><?php echo esc_html($group_conditions); ?></option>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </select>

                <div class="pisol-anfw-condition-details" style="display:none;">
                    <div class="pisol-anfw-operator-container"></div>
                    <div class="pisol-anfw-value-container"></div>
                </div>

                <button type="button" class="button pisol-anfw-remove-condition"><?php esc_html_e('Remove', 'advance-notification-for-woocommerce'); ?></button>
            </div>
        </div>
    </script>
    
    <!-- We'll keep this template but not use it anymore -->
    <script type="text/template" id="tmpl-pisol-anfw-logic-divider">
        <div class="pisol-anfw-logic-divider">
            <select name="pisol_anfw_conditions[{{ data.groupId }}][conditions][{{ data.conditionId }}][logic]" class="pisol-anfw-logic">
                <option value="AND"><?php esc_html_e('AND', 'advance-notification-for-woocommerce'); ?></option>
                <option value="OR"><?php esc_html_e('OR', 'advance-notification-for-woocommerce'); ?></option>
            </select>
        </div>
    </script>
</div>
