<?php
namespace PISOL\ANFW\ADMIN;

/**
 * Order Subtotal Condition
 * This class checks if the order subtotal meets specified conditions.
 * @package Advance_Notification_For_WooCommerce
 */

defined('ABSPATH') || exit;

/**
 * Class for order subtotal condition
 */
class Order_Subtotal extends Base_Condition {
    
    /**
     * Constructor
     */
    public function __construct() {
        parent::__construct();
    }

    function supported_trigger(){
        return array(
            'new_order'
        );
    }
    
    
    /**
     * Get condition ID
     *
     * @return string
     */
    public function get_id() {
        return 'order_subtotal';
    }
    
    /**
     * Get condition name
     *
     * @return string
     */
    public function get_name($trigger_type= '') {
        return __('Order Subtotal', 'advance-notification-for-woocommerce');
    }
    
    /**
     * Get group for this condition
     *
     * @return string
     */
    public function get_group() {
        return 'Order';
    }
    
    /**
     * Get available operators
     *
     * @return array
     */
    public function get_operators($logic, $trigger_type = '') {
        return array(
            'eq' => __('Equal to', 'advance-notification-for-woocommerce'),
            'neq' => __('Not equal to', 'advance-notification-for-woocommerce'),
            'gt' => __('Greater than', 'advance-notification-for-woocommerce'),
            'gte' => __('Greater than or equal to', 'advance-notification-for-woocommerce'),
            'lt' => __('Less than', 'advance-notification-for-woocommerce'),
            'lte' => __('Less than or equal to', 'advance-notification-for-woocommerce'),
        );
    }
    
    /**
     * Get HTML for value field
     *
     * @param string $html Current HTML.
     * @param string $condition_id Condition ID.
     * @param string $unused_param Unused parameter.
     * @param string $current_value Current value.
     * @return string
     */
    public function get_value_field($html, $condition_id, $unused_param, $current_value) {
        ob_start();
        ?>
        <div class="pisol-anfw-subtotal-value">
            <input 
                type="number" 
                name="pisol_anfw_conditions[<?php echo esc_attr($condition_id); ?>][value]"
                value="<?php echo esc_attr($current_value); ?>"
                step="0.01"
                min="0"
                class="regular-text"
                placeholder="<?php esc_attr_e('Subtotal amount', 'advance-notification-for-woocommerce'); ?>"
            >
            <span class="description"><?php echo esc_html(get_woocommerce_currency_symbol()); ?></span>
        </div>
        <?php
        return ob_get_clean();
    }
    
    public function is_match($return, $data, $trigger_type, $operator, $value) {
        if($trigger_type == 'new_order') {
            return $this->is_match_for_new_order($return, $data, $trigger_type, $operator, $value);
        }

        return false;
    }

    public function is_match_for_new_order($return, $data, $trigger_type, $operator, $value) {
        $order = isset($data['order']) ? $data['order'] : null;

        if (!$order || !is_a($order, 'WC_Order')) {
            return false;
        }
        
        $subtotal = $order->get_subtotal();
        $value = (float) $value;
        
        switch ($operator) {
            case 'eq':
                return $subtotal == $value;
            case 'neq':
                return $subtotal != $value;
            case 'gt':
                return $subtotal > $value;
            case 'gte':
                return $subtotal >= $value;
            case 'lt':
                return $subtotal < $value;
            case 'lte':
                return $subtotal <= $value;
            default:
                return false;
        }
    }
}
