<?php
namespace PISOL\ANFW\ADMIN;
/**
 * Order Status Condition
 *
 * @package Auto_Assign_Order_Tags_For_WooCommerce
 */

defined('ABSPATH') || exit;

/**
 * Class for checking order status for an order
 */
class Order_Status extends Base_Condition {
    /**
     * Constructor
     */
    public function __construct() {
        parent::__construct();
    }

    function supported_trigger(){
        return array(
            'new_order'
        );
    }
    

    /**
     * Get condition ID
     *
     * @return string
     */
    public function get_id() {
        return 'order_status';
    }

    /**
     * Get condition name
     *
     * @return string
     */
    public function get_name($trigger_type= '') {
        return __('Order Status', 'advance-notification-for-woocommerce');
    }

    /**
     * Get group for this condition
     *
     * @return string
     */
    public function get_group() {
        return 'Order';
    }

    /**
     * Get available operators
     *
     * @return array
     */
    public function get_operators($logic, $trigger_type = '') {
        return array(
            'in' => __('Order status is', 'advance-notification-for-woocommerce'),
            'not_in' => __('Order status is not', 'advance-notification-for-woocommerce'),
        );
    }

    /**
     * Get HTML for value field
     *
     * @param string $html Current HTML.
     * @param string $condition_id Condition ID.
     * @param string $unused_param Unused parameter.
     * @param mixed $current_value Current value.
     * @return string
     */
    public function get_value_field($html, $condition_id, $unused_param, $current_value) {
        $statuses = $this->get_order_statuses();
        $current_statuses = array();
        if (!empty($current_value)) {
            $current_statuses = is_array($current_value) ? $current_value : array($current_value);
        }
        ob_start();
        ?>
        <select name="pisol_anfw_conditions[<?php echo esc_attr($condition_id); ?>][value][]"
                class="pisol-anfw-select"
                multiple="multiple"
                style="width: 100%; min-height: 100px;">
            <?php foreach ($statuses as $status_key => $status_label) : ?>
                <option value="<?php echo esc_attr($status_key); ?>"
                        <?php echo in_array($status_key, $current_statuses, true) ? 'selected="selected"' : ''; ?>>
                    <?php echo esc_html($status_label); ?>
                </option>
            <?php endforeach; ?>
        </select>
        <p class="description">
            <?php esc_html_e('Select one or more order statuses to match. Hold Ctrl/Cmd key to select multiple statuses.', 'advance-notification-for-woocommerce'); ?>
        </p>
        <?php
        return ob_get_clean();
    }

    public function is_match($return, $data, $trigger_type, $operator, $value) {
        if($trigger_type == 'new_order') {
            return $this->is_match_for_new_order($return, $data, $trigger_type, $operator, $value);
        }

        return false;
    }

    public function is_match_for_new_order($return, $data, $trigger_type, $operator, $value) {
        $order = isset($data['order']) ? $data['order'] : null;

        if (!$order || !is_a($order, 'WC_Order') || empty($value)) {
            return false;
        }
        $statuses_to_check = is_array($value) ? $value : array($value);
        $order_status = $order->get_status();
        if (empty($order_status)) {
            return false;
        }
        $is_in_list = in_array($order_status, $statuses_to_check, true);
        if ($operator === 'in') {
            return $is_in_list;
        } else { // 'not_in'
            return !$is_in_list;
        }
    }

    /**
     * Get all available order statuses
     *
     * @return array
     */
    private function get_order_statuses() {
        if (!function_exists('wc_get_order_statuses')) {
            return array();
        }
        $raw_statuses = wc_get_order_statuses();
        $statuses = array();
        foreach ($raw_statuses as $status_key => $status_label) {
            $trimmed_key = str_replace('wc-', '', $status_key);
            $statuses[$trimmed_key] = $status_label;
        }
        return $statuses;
    }
}
