<?php
namespace PISOL\ANFW\ADMIN;
/**
 * Day Condition
 *
 * @package Auto_Assign_Order_Tags_For_WooCommerce
 */

defined('ABSPATH') || exit;

/**
 * Class for checking if current day matches selected days
 */
class Day extends Base_Condition {
    /**
     * Constructor
     */
    public function __construct() {
        parent::__construct();
    }

    function supported_trigger(){
        return array(
            'new_order',
            'low_stock',
            'out_of_stock',
            'backorder'
        );
    }

    /**
     * Get condition ID
     *
     * @return string
     */
    public function get_id() {
        return 'day';
    }

    /**
     * Get condition name
     *
     * @return string
     */
    public function get_name($trigger_type= '') {
        return __('Day of Week', 'advance-notification-for-woocommerce');
    }

    /**
     * Get group for this condition
     *
     * @return string
     */
    public function get_group() {
        return 'General';
    }

    /**
     * Get available operators
     *
     * @return array
     */
    public function get_operators($logic, $trigger_type = '') {
        return array(
            'in' => __('Is one of', 'advance-notification-for-woocommerce'),
            'not_in' => __('Is not one of', 'advance-notification-for-woocommerce'),
        );
    }

    /**
     * Get HTML for value field
     *
     * @param string $html Current HTML.
     * @param string $condition_id Condition ID.
     * @param string $unused_param Unused parameter.
     * @param mixed $current_value Current value.
     * @return string
     */
    public function get_value_field($html, $condition_id, $unused_param, $current_value) {
        $days = $this->get_days();
        $current_days = array();
        if (!empty($current_value)) {
            $current_days = is_array($current_value) ? $current_value : array($current_value);
        }
        ob_start();
        ?>
        <select name="pisol_anfw_conditions[<?php echo esc_attr($condition_id); ?>][value][]"
                class="pisol-anfw-select"
                multiple="multiple"
                style="width: 100%; min-height: 100px;">
            <?php foreach ($days as $day_key => $day_label) : ?>
                <option value="<?php echo esc_attr($day_key); ?>"
                        <?php echo in_array($day_key, $current_days) ? 'selected="selected"' : ''; ?>>
                    <?php echo esc_html($day_label); ?>
                </option>
            <?php endforeach; ?>
        </select>
        <p class="description">
            <?php esc_html_e('Select one or more days. 0=Sunday, 6=Saturday. Hold Ctrl/Cmd key to select multiple.', 'advance-notification-for-woocommerce'); ?>
        </p>
        <?php
        return ob_get_clean();
    }

    /**
     * Check if current day matches selected days
     */
    public function is_match($return, $data, $trigger_type, $operator, $value) {
        if (empty($value)) {
            return false;
        }
        $selected_days = is_array($value) ? $value : array($value);
        $current_day = (int) current_time('w'); // 0 (for Sunday) through 6 (for Saturday)
        $is_in_list = in_array($current_day, array_map('intval', $selected_days), true);
        if ($operator === 'in') {
            return $is_in_list;
        } else { // 'not_in'
            return !$is_in_list;
        }
    }

    /**
     * Get days of the week
     *
     * @return array
     */
    private function get_days() {
        return array(
            0 => __('Sunday', 'advance-notification-for-woocommerce'),
            1 => __('Monday', 'advance-notification-for-woocommerce'),
            2 => __('Tuesday', 'advance-notification-for-woocommerce'),
            3 => __('Wednesday', 'advance-notification-for-woocommerce'),
            4 => __('Thursday', 'advance-notification-for-woocommerce'),
            5 => __('Friday', 'advance-notification-for-woocommerce'),
            6 => __('Saturday', 'advance-notification-for-woocommerce'),
        );
    }
}
