<?php
namespace PISOL\ANFW\ADMIN;
/**
 * Date Time Range Condition
 *
 * @package Auto_Assign_Order_Tags_For_WooCommerce
 */

defined('ABSPATH') || exit;

/**
 * Class for checking if current date/time is within a given range
 */
class Date_Time_range extends Base_Condition {
    /**
     * Constructor
     */
    public function __construct() {
        parent::__construct();
    }

    function supported_trigger(){
        return array(
            'new_order',
            'low_stock',
            'out_of_stock',
            'backorder'
        );
    }

    /**
     * Get condition ID
     *
     * @return string
     */
    public function get_id() {
        return 'date_time_range';
    }

    /**
     * Get condition name
     *
     * @return string
     */
    public function get_name($trigger_type= '') {
        return __('Date/Time Range', 'advance-notification-for-woocommerce');
    }

    /**
     * Get group for this condition
     *
     * @return string
     */
    public function get_group() {
        return 'General';
    }

    /**
     * Get available operators
     *
     * @return array
     */
    public function get_operators($logic, $trigger_type = '') {
        return array(
            'in' => __('Within range', 'advance-notification-for-woocommerce'),
            'not_in' => __('Not within range', 'advance-notification-for-woocommerce'),
        );
    }

    /**
     * Get HTML for value field
     *
     * @param string $html Current HTML.
     * @param string $condition_id Condition ID.
     * @param string $unused_param Unused parameter.
     * @param mixed $current_value Current value.
     * @return string
     */
    public function get_value_field($html, $condition_id, $unused_param, $current_value) {
        $start = isset($current_value['start']) ? esc_attr($current_value['start']) : '';
        $end = isset($current_value['end']) ? esc_attr($current_value['end']) : '';
        ob_start();
        ?>
        <label><?php esc_html_e('Start Date/Time:', 'advance-notification-for-woocommerce'); ?></label>
        <input type="datetime-local" name="pisol_anfw_conditions[<?php echo esc_attr($condition_id); ?>][value][start]" value="<?php echo $start; ?>" style="width: 100%;" />
        <br/>
        <label><?php esc_html_e('End Date/Time:', 'advance-notification-for-woocommerce'); ?></label>
        <input type="datetime-local" name="pisol_anfw_conditions[<?php echo esc_attr($condition_id); ?>][value][end]" value="<?php echo $end; ?>" style="width: 100%;" />
        <p class="description">
            <?php esc_html_e('Select the start and end date/time for the range.', 'advance-notification-for-woocommerce'); ?>
        </p>
        <?php
        return ob_get_clean();
    }

    /**
     * Check if current date/time is within the given range
     */
    public function is_match($return, $data, $trigger_type, $operator, $value) {
        if (empty($value['start']) || empty($value['end'])) {
            return false;
        }
        $now = current_time('Y-m-d H:i');
        $now_ts = strtotime($now);
        $start_ts = strtotime($value['start']);
        $end_ts = strtotime($value['end']);
        $is_in_range = ($now_ts >= $start_ts && $now_ts <= $end_ts);
        if ($operator === 'in') {
            return $is_in_range;
        } else { // 'not_in'
            return !$is_in_range;
        }
    }
}
