<?php
/**
 * Abstract class for defining different types of triggers for notifications.
 *
 * @package Advance_Notification_For_WooCommerce
 */

namespace PISOL\ANFW\ADMIN;

/**
 * Abstract Class Trigger_types
 *
 * This abstract class allows us to define the different types of triggers for notifications.
 */
abstract class Trigger {

    public function __construct() {
        // Register this trigger type
        add_filter('pisol_anfw_triggers', array($this, 'register_triggers'));
    }
    /**
     * Get the unique ID of the trigger type.
     *
     * @return string
     */
    abstract public function get_id();

    /**
     * Get the human-readable name of the trigger type.
     *
     * @return string
     */
    abstract public function get_name();

    /**
     * Get the description of the trigger type.
     *
     * @return string
     */
    abstract public function get_description();

    function register_triggers($triggers) {
        $triggers[$this->get_id()] = array(
            'name' => $this->get_name(),
            'description' => $this->get_description(),
        );
        return $triggers;
    }
}
