<?php
namespace PISOL\ANFW\ADMIN;

if ( ! defined( 'ABSPATH' ) ) exit;

class Notifications_Columns {
    // Singleton instance
    private static $instance = null;

    // Prevent direct instantiation
    private function __construct() {
        add_filter('manage_pisol_anfw_notice_posts_columns', array($this, 'add_columns'));
        add_action('manage_pisol_anfw_notice_posts_custom_column', array($this, 'render_column'), 10, 2);
    }

    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    // Add the Trigger type column
    public function add_columns($columns) {
        $insert_after = 'title';
        $new_columns = array();
        foreach ($columns as $key => $value) {
            $new_columns[$key] = $value;
            if ($key === $insert_after) {
                $new_columns['pisol_anfw_trigger_type'] = __('Trigger type', 'advance-notification-for-woocommerce');
                $new_columns['pisol_anfw_excerpt'] = __('Description', 'advance-notification-for-woocommerce');
            }
        }
        return $new_columns;
    }

    // Render the Trigger type column
    public function render_column($column, $post_id) {
        if ($column === 'pisol_anfw_trigger_type') {
            $trigger = get_post_meta($post_id, '_pisol_anfw_trigger', true);
            if ($trigger) {
                // Try to get human readable name from triggers filter
                $triggers = apply_filters('pisol_anfw_triggers', array());
                if (isset($triggers[$trigger]['name'])) {
                    echo esc_html($triggers[$trigger]['name']);
                } else {
                    echo esc_html($trigger);
                }
            } else {
                echo '-';
            }
        } elseif ($column === 'pisol_anfw_excerpt') {
            $excerpt = get_the_excerpt($post_id);
            echo $excerpt ? esc_html($excerpt) : '-';
        }
    }
}

// No need to call get_instance(); Singleton will be loaded elsewhere.