<?php
namespace PISOL\ANFW\ADMIN;
/**
 * Abstract class for Notification Types
 *
 * This class will be extended to create specific notification types like Email, Telegram, WhatsApp, etc.
 */

abstract class Notification_Type {
    function __construct(){
        add_action('pisol_anfw_action_field', [$this, 'field'], 10);
        add_action('pisol_anfw_action_field_save', [$this, 'save'], 10, 3);
        add_action('pisol_anfw_send_notification', [$this, 'send'], 10, 2);
    }

    abstract public function  field($post);
    
    abstract public function  save($post_id, $post, $update);

    abstract public function  send($notification_id, $data);
}
