<?php
namespace PISOL\ANFW\ADMIN;

class NewOrder_Trigger_Option extends Option {

    static $instance = null;

    static function get_instance() {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function __construct() {
        parent::__construct();
    }

    public function get_tab_name() {
        return __('New Order Trigger', 'advance-notification-for-woocommerce');
    }

    public function get_tab() {
        return 'default';
    }

    public function get_setting_key() {
        return 'new_order_trigger';
    }

    public function init_settings() {
        $statuses = $this->get_all_order_status_transitions();
        $this->settings = array(
            array('field'=>'title', 'class'=> 'bg-primary text-light', 'class_title'=>'text-light font-weight-light h4', 'label'=> __("When to trigger the notification of New order",'advance-notification-for-woocommerce'), 'type'=>"setting_category"),

            array('field'=>'pi_anfw_new_order_trigger_order_status', 'label'=>__('When Order status change','advance-notification-for-woocommerce'),'type'=>'multiselect', 'default'=>['pending|processing', 'pending|completed', 'failed|processing', 'failed|completed'],   'desc'=>__("when the order status changes from one to another, the New order trigger will be fired. You can select multiple order status transitions.",'advance-notification-for-woocommerce'), 'value' => $statuses),
        );
    }

    public function get_all_order_status_transitions() {
        $statuses = wc_get_order_statuses(); // array('wc-pending' => 'Pending', ...)
        $transitions = array();
        foreach ($statuses as $from_key => $from_label) {
            foreach ($statuses as $to_key => $to_label) {
                if ($from_key !== $to_key) {
                    // Remove 'wc-' prefix for keys and labels
                    $from = str_replace('wc-', '', $from_key);
                    $to = str_replace('wc-', '', $to_key);
                    $transitions["{$from}|{$to}"] = "{$from_label} > {$to_label}";
                }
            }
        }
        return $transitions;
    }
}

