<?php
namespace PISOL\ANFW\ADMIN;

class Menu{

    public $plugin_name;
    public $menu;
    public $version;

    protected static $instance = null;

    public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
    
    function __construct(){
        $this->plugin_name = 'advance-notification-for-woocommerce';
        $this->version = PISOL_ANFW_VERSION;
        add_action( 'admin_menu', array($this,'plugin_menu') );
    }

    function plugin_menu(){

        $require_capability = 'manage_woocommerce';
        
        $this->menu = add_menu_page(
            __( 'Setting', 'advance-notification-for-woocommerce' ),
            __( 'Notifications', 'advance-notification-for-woocommerce' ),
            $require_capability,
            'advance-notification-for-woocommerce',
            array($this, 'menu_option_page'),
            PISOL_ANFW_FOLDER_URL.'/admin/img/pi.svg',
            6
        );

        add_submenu_page(
            'advance-notification-for-woocommerce', // parent slug
            __( 'Settings', 'advance-notification-for-woocommerce' ), // page title
            __( 'Settings', 'advance-notification-for-woocommerce' ), // menu title
            $require_capability,
            'advance-notification-for-woocommerce',
            array($this, 'menu_option_page'),
            2
        );

        add_action("load-".$this->menu, array($this,"bootstrap_style"));
 
    }

    public function bootstrap_style() {
        add_thickbox();
        wp_enqueue_style('woocommerce_admin_styles');
        wp_enqueue_script( 'selectWoo');
		wp_enqueue_style( $this->plugin_name."_bootstrap", plugin_dir_url( __FILE__ ) . 'assets/css/bootstrap.css', array(), $this->version, 'all' );
        wp_enqueue_script(
            $this->plugin_name . '_option_js',
            plugin_dir_url(__FILE__) . 'assets/js/option.js',
            array('jquery'),
            $this->version,
            true
        );
	}

    function menu_option_page(){
        if(function_exists('settings_errors')){
            settings_errors();
        }
        ?>
        <div class="bootstrap-wrapper">
        <div class="pisol-container mt-2">
            <div class="pisol-row">
                    <div class="col-12">
                        <div class='bg-dark'>
                        <div class="pisol-row">
                            <div class="col-12 col-sm-2 py-2">
                                    <a href="https://www.piwebsolution.com/" target="_blank"><img class="img-fluid ml-2" src="<?php echo esc_url( plugin_dir_url( __FILE__ ) ); ?>img/pi-web-solution.svg"></a>
                            </div>
                            <div class="col-12 col-sm-10 d-flex">
                                
                            </div>
                        </div>
                        </div>
                    </div>
            </div>
            <div class="pisol-row">
                
                <div class="col-12">
                <div class="bg-light border pl-3 pr-3 pb-3 pt-0">
                    <div class="pisol-row">
                    <div class="col-12 col-md-2 px-0 border-right">
                                <?php do_action($this->plugin_name.'_tab'); ?>
                    </div>
                        <div class="col">
                        <?php do_action($this->plugin_name.'_tab_content'); ?>
                        </div>
                        <?php do_action($this->plugin_name.'_promotion'); ?>
                    </div>
                </div>
                </div>
            </div>
        </div>
        </div>
        <?php
    }

   
}