<?php
namespace PISOL\ANFW\ADMIN;
/**
 * Email Notification Action class
 * 
 * Handles email notifications when order tags are assigned
 *
 * @package Auto_Assign_Order_Tags_For_WooCommerce
 * @subpackage Admin
 */

defined('ABSPATH') || exit;

/**
 * Email Notification Action - Singleton class
 * 
 * @since 1.0.0
 */
class Email_Notification Extends Notification_Type{

    /**
     * Instance of this class
     *
     * @var Email_Notification_Action
     */
    private static $instance = null;

    /**
     * Get the singleton instance
     *
     * @return Email_Notification_Action
     */
    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    function field($post){
        // Get saved actions data
        $send_email = get_post_meta($post->ID, '_pisol_anfw_action_send_email', true);
        $email_recipient = get_post_meta($post->ID, '_pisol_anfw_email_recipient', true);
        $email_subject = get_post_meta($post->ID, '_pisol_anfw_email_subject', true);
        $email_message = get_post_meta($post->ID, '_pisol_anfw_email_message', true);
        $email_execution_frequency = get_post_meta($post->ID, '_pisol_anfw_email_execution_frequency', true);
        
        // Set defaults if empty
        $send_email = !empty($send_email) ? $send_email : '0';
        $email_recipient = !empty($email_recipient) ? $email_recipient : get_option('admin_email');
        $email_subject = !empty($email_subject) ? $email_subject : __('Email subject', 'advance-notification-for-woocommerce');
        $email_message = !empty($email_message) ? $email_message : __('Email message', 'advance-notification-for-woocommerce');
        $email_execution_frequency = !empty($email_execution_frequency) ? $email_execution_frequency : 'always';
        
        include PISOL_ANFW_FOLDER_PATH . 'admin/templates/email-notification-action.php';
    }

    function save($post_id, $post, $update){
        if (!isset($_POST['pisol_anfw_actions_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['pisol_anfw_actions_nonce'])), 'pisol_anfw_save_actions')) {
            return;
        }
        // Save send email setting
        $send_email = isset($_POST['pisol_anfw_action_send_email']) ? '1' : '0';
        update_post_meta($post_id, '_pisol_anfw_action_send_email', $send_email);

        // Save email recipient
        if (isset($_POST['pisol_anfw_email_recipient'])) {
            $recipients = sanitize_text_field(wp_unslash($_POST['pisol_anfw_email_recipient']));
            update_post_meta($post_id, '_pisol_anfw_email_recipient', $recipients);
        }

        // Save email subject
        if (isset($_POST['pisol_anfw_email_subject'])) {
            $subject = sanitize_text_field(wp_unslash($_POST['pisol_anfw_email_subject']));
            update_post_meta($post_id, '_pisol_anfw_email_subject', $subject);
        }

        // Save email message
        if (isset($_POST['pisol_anfw_email_message'])) {
            $message = sanitize_textarea_field(wp_unslash($_POST['pisol_anfw_email_message']));
            update_post_meta($post_id, '_pisol_anfw_email_message', $message);
        }
    }   
    
    /**
     * Maybe send email notification when a tag is applied
     *
     * @param int $tag_id Tag ID that was applied
     * @param int $order_id Order ID the tag was applied to
     */
    public function send($notification_id, $data = []) {
        $send_email = get_post_meta($notification_id, '_pisol_anfw_action_send_email', true);
        if ('1' !== $send_email) {
            return;
        }
        
       
        // Get email content
        $email_recipient = get_post_meta($notification_id, '_pisol_anfw_email_recipient', true);
        $email_subject = get_post_meta($notification_id, '_pisol_anfw_email_subject', true);
        $email_message = get_post_meta($notification_id, '_pisol_anfw_email_message', true);

        if (!empty($email_recipient)) {
            self::send_email($email_recipient, $email_subject, $email_message);
        }
    }

    static function send_email($email_recipient, $email_subject, $email_message){
        $mailer = WC()->mailer();
        $email_heading = $email_subject;
        $message_body  = $email_message;

        $wrapped_message = $mailer->wrap_message( $email_heading, $message_body );
        $headers = array('Content-Type: text/html; charset=UTF-8');
        return $mailer->send( $email_recipient, $email_subject, $wrapped_message, $headers );
    }
}