<?php
namespace PISOL\ANFW\ADMIN;

/**
 * Bootstrap for admin side functionality
 *
 * @package Auto_Assign_Order_Tags_For_WooCommerce
 */

defined('ABSPATH') || exit;

/**
 * Class for bootstrapping admin functionality
 */
class Admin_Bootstrap {

    /**
     * The single instance of this class
     *
     * @var Admin_Bootstrap
     */
    private static $instance = null;

    /**
     * Main instance
     * 
     * Ensures only one instance is loaded or can be loaded.
     *
     * @return Admin_Bootstrap
     */
    public static function get_instance() {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Constructor
     */
    public function __construct() {
        // Load dependent classes
        $this->load_dependencies();
    }

    /**
     * Load dependencies
     */
    private function load_dependencies() {
        Menu::get_instance();
        Notifications::get_instance();
        Notification_Form::get_instance();
        NewOrder_Trigger_Option::get_instance();
        Notifications_Columns::get_instance();

        /** Triggers */
        new NewOrder_Trigger();
        new Low_Stock_Trigger();
        new Outof_Stock_Trigger();
        new Backorder_Trigger();

        /** Conditions */
        new Product();
        new Product_Category();
        new Order_Subtotal();
        new Order_Status();
        new Date_Time_Range();
        new Day();

        /** Notification types */
        Email_Notification::get_instance();
    }
}