jQuery(document).ready(function($) {
    /**
     * Get order ID from URL or DOM depending on the screen
     */
    function getOrderId() {
        if (pisol_aaot_params.is_hpos) {
            // For HPOS screens, get from URL
            const urlParams = new URLSearchParams(window.location.search);
            return urlParams.get('id');
        } else {
            // For classic post screens, get from post ID
            return $('#post_ID').val();
        }
    }

    // Initialize select2 for better multi-select experience
    if ($.fn.selectWoo) {
        $('.pisol-aaot-tag-selector select').selectWoo({
            placeholder: pisol_aaot_params.select_placeholder,
            width: '100%'
        });
    }

    // Handle AJAX update of tags
    $(document).on('click', '.pisol-aaot-tag-selector button[name="pisol_aaot_update_tags"]', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var $container = $button.closest('.pisol-aaot-tag-selector');
        var $select = $container.find('select[name="pisol_aaot_order_tags[]"]');
        var $metaBox = $button.closest('#pisol_aaot_order_tags');
        
        // Get order ID
        var orderId = getOrderId();
        if (!orderId) {
            alert(pisol_aaot_params.error_message);
            return;
        }

        // Get selected tag IDs
        var tagIds = $select.val() || [];
        
        // Show loading state
        $button.prop('disabled', true).text(pisol_aaot_params.updating_text);
        
        // Make AJAX request
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'pisol_aaot_edit_tag',
                order_id: orderId,
                tag_ids: tagIds,
                security: pisol_aaot_params.nonce
            },
            success: function(response) {
                if (response.success) {
                    // Refresh the meta box content
                    $metaBox.find('.inside').html(response.data.html);
                    
                    // Reinitialize select2
                    if ($.fn.selectWoo) {
                        $('.pisol-aaot-tag-selector select').selectWoo({
                            placeholder: pisol_aaot_params.select_placeholder,
                            width: '100%'
                        });
                    }
                    
                    // Show success message
                    if (response.data.message) {
                        $('<div class="notice notice-success inline"><p>' + response.data.message + '</p></div>')
                            .insertBefore($metaBox.find('.inside'))
                            .delay(3000)
                            .fadeOut();
                    }
                } else {
                    // Show error message
                    $('<div class="notice notice-error inline"><p>' + response.data.message + '</p></div>')
                        .insertBefore($metaBox.find('.inside'))
                        .delay(3000)
                        .fadeOut();
                }
            },
            error: function() {
                // Show generic error message
                $('<div class="notice notice-error inline"><p>' + pisol_aaot_params.error_message + '</p></div>')
                    .insertBefore($metaBox.find('.inside'))
                    .delay(3000)
                    .fadeOut();
            },
            complete: function() {
                // Reset button state
                $button.prop('disabled', false).text(pisol_aaot_params.update_text);
            }
        });
    });
});
