/**
 * Order Tag Actions JavaScript
 * 
 * Handles the accordion functionality for the order tag actions
 */
(function($) {
    'use strict';

    // Initialize when document is ready
    $(document).ready(function() {
        initActionAccordion();
    });

    /**
     * Initialize the accordion behavior for tag actions
     */
    function initActionAccordion() {
        // Toggle accordion content when checkbox is clicked
        $('.pisol-anfw-action-toggle').on('change', function() {
            var $accordion = $(this).closest('.pisol-anfw-action-accordion');
            var $content = $accordion.find('.pisol-anfw-action-content');
            
            if ($(this).is(':checked')) {
                $content.slideDown(300);
            } else {
                $content.slideUp(300);
            }
        });

        // Also allow clicking on the header to toggle the checkbox
        $('.pisol-anfw-action-header').on('click', function(e) {
            // Don't trigger if clicking on the checkbox itself
            if ($(e.target).is('input[type="checkbox"]')) {
                return;
            }
            
            var $checkbox = $(this).find('input[type="checkbox"]');
            $checkbox.prop('checked', !$checkbox.prop('checked')).trigger('change');
        });
    }

})(jQuery);