<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Get spots meta for a post.
 *
 * @param int $post_id Post ID.
 * @return array Sanitized spots data.
 */
function advaimma_get_spots( $post_id ) {
	$post_id = absint( $post_id );

	if ( ! $post_id ) {
		return array();
	}

	$spots = get_post_meta( $post_id, 'advaimma_spots', true );

	if ( ! is_array( $spots ) ) {
		return array();
	}

	$sanitized_spots = array();

	foreach ( $spots as $spot ) {
		if ( ! is_array( $spot ) ) {
			continue;
		}

		$sanitized_spots[] = array(
			'title'      => isset( $spot['title'] ) ? sanitize_text_field( $spot['title'] ) : '',
			'content'    => isset( $spot['content'] ) ? wp_kses_post( $spot['content'] ) : '',
			'icon'       => isset( $spot['icon'] ) ? preg_replace( '/[^a-z0-9\-]/', '', strtolower( $spot['icon'] ) ) : '',
			'icon_image' => isset( $spot['icon_image'] ) ? esc_url_raw( $spot['icon_image'] ) : '',
			'link'       => isset( $spot['link'] ) ? esc_url_raw( $spot['link'] ) : '',
			'trigger'    => ( isset( $spot['trigger'] ) && in_array( $spot['trigger'], array( 'hover', 'click' ), true ) ) ? $spot['trigger'] : 'hover',
			'x'          => isset( $spot['x'] ) ? floatval( $spot['x'] ) : 50,
			'y'          => isset( $spot['y'] ) ? floatval( $spot['y'] ) : 50,
		);
	}

	return $sanitized_spots;
}
