<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class ADVAIMMA_Frontend {

	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_frontend_assets' ) );
		add_shortcode( 'advaimma_map', array( $this, 'shortcode_map' ) );
	}

	/**
	 * Enqueue frontend CSS & JS.
	 */
	public function enqueue_frontend_assets() {
		wp_enqueue_script(
			'advaimma-frontend',
			ADVAIMMA_URL . 'assets/js/frontend.js',
			array( 'jquery' ),
			ADVAIMMA_VERSION,
			true
		);

		wp_enqueue_style(
			'advaimma-frontend-style',
			ADVAIMMA_URL . 'assets/css/frontend.css',
			array(),
			ADVAIMMA_VERSION
		);
	}

	/**
	 * Shortcode handler: [advaimma_map id="123"]
	 */
	public function shortcode_map( $atts ) {
		$atts = shortcode_atts(
			array(
				'id' => 0,
			),
			$atts,
			'advaimma_map'
		);

		$post_id = intval( $atts['id'] );
		if ( $post_id <= 0 ) {
			return '';
		}

		$image_id  = get_post_meta( $post_id, 'advaimma_image_id', true );
		$image_url = $image_id ? wp_get_attachment_image_url( intval( $image_id ), 'full' ) : '';
		$spots     = get_post_meta( $post_id, 'advaimma_spots', true );
		$colors    = get_post_meta( $post_id, 'advaimma_colors', true );

		// Default colors (fallbacks)
		$defaults = array(
			'title_color'     => '#ffffff',
			'content_color'   => '#ffffff',
			'tip_bg_color'    => '#333333',
			'point_bg_color'  => '#000000',
			'number_color'    => '#ffffff',
		);
		$colors = wp_parse_args( $colors, $defaults );

		if ( ! is_array( $spots ) || empty( $spots ) ) {
			return '';
		}

		ob_start();
		?>
		<div class="advaimma-wrap" data-map-id="<?php echo esc_attr( $post_id ); ?>">
			<style>
				/* Inject dynamic colors from admin */
				.advaimma-wrap[data-map-id="<?php echo esc_attr( $post_id ); ?>"] .advaimma-tip {
					background-color: <?php echo esc_attr( $colors['tip_bg_color'] ); ?>;
					color: <?php echo esc_attr( $colors['content_color'] ); ?>;
				}
				.advaimma-wrap[data-map-id="<?php echo esc_attr( $post_id ); ?>"] .advaimma-tip h4 {
					color: <?php echo esc_attr( $colors['title_color'] ); ?>;
				}
				.advaimma-wrap[data-map-id="<?php echo esc_attr( $post_id ); ?>"] .advaimma-point {
					background-color: <?php echo esc_attr( $colors['point_bg_color'] ); ?>;
				}
				.advaimma-wrap[data-map-id="<?php echo esc_attr( $post_id ); ?>"] .advaimma-number {
					color: <?php echo esc_attr( $colors['number_color'] ); ?>;
				}
			</style>

			<div class="advaimma-image" <?php echo $image_url ? 'style="background-image:url(' . esc_url( $image_url ) . ');"' : ''; ?>>
				<?php foreach ( $spots as $i => $s ) :
					$title      = isset( $s['title'] ) ? $s['title'] : '';
					$content    = isset( $s['content'] ) ? $s['content'] : '';
					$icon_image = isset( $s['icon_image'] ) ? esc_url( $s['icon_image'] ) : '';
					$link       = isset( $s['link'] ) ? esc_url( $s['link'] ) : '';
					$trigger    = ( isset( $s['trigger'] ) && in_array( $s['trigger'], array( 'hover', 'click' ), true ) ) ? $s['trigger'] : 'hover';
					$x          = isset( $s['x'] ) ? floatval( $s['x'] ) : 50;
					$y          = isset( $s['y'] ) ? floatval( $s['y'] ) : 50;
				?>
					<button
						type="button"
						class="advaimma-point"
						data-trigger="<?php echo esc_attr( $trigger ); ?>"
						style="left:<?php echo esc_attr( round( min( 100, max( 0, $x ) ), 2 ) ); ?>%; top:<?php echo esc_attr( round( min( 100, max( 0, $y ) ), 2 ) ); ?>%;"
						<?php echo $link ? 'data-link="' . esc_url( $link ) . '"' : ''; ?>
						aria-label="<?php echo esc_attr( $title ); ?>"
					>
						<span class="advaimma-icon">
							<?php if ( $icon_image ) : ?>
								<img src="<?php echo esc_url( $icon_image ); ?>" alt="" />
							<?php else : ?>
								<span class="advaimma-number"><?php echo esc_html( $i + 1 ); ?></span>
							<?php endif; ?>
						</span>

						<div class="advaimma-tip">
							<?php if ( $title ) : ?>
								<h4><?php echo esc_html( $title ); ?></h4>
							<?php endif; ?>
							<div class="advaimma-tip-content"><?php echo wp_kses_post( $content ); ?></div>
						</div>
					</button>
				<?php endforeach; ?>
			</div>
		</div>
		<?php
		return ob_get_clean();
	}
}
