<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Registers the Custom Post Type for Image Maps
 */
class ADVAIMMA_CPT {

	/**
	 * Register the CPT
	 */
	public static function register_post_type() {
		$labels = array(
			'name'               => __( 'Image Maps', 'advance-image-mapping' ),
			'singular_name'      => __( 'Image Map', 'advance-image-mapping' ),
			'add_new'            => __( 'Add New', 'advance-image-mapping' ),
			'add_new_item'       => __( 'Add New Image Map', 'advance-image-mapping' ),
			'edit_item'          => __( 'Edit Image Map', 'advance-image-mapping' ),
			'new_item'           => __( 'New Image Map', 'advance-image-mapping' ),
			'all_items'          => __( 'All Image Maps', 'advance-image-mapping' ),
			'view_item'          => __( 'View Image Map', 'advance-image-mapping' ),
			'search_items'       => __( 'Search Image Maps', 'advance-image-mapping' ),
			'not_found'          => __( 'No image maps found', 'advance-image-mapping' ),
			'not_found_in_trash' => __( 'No image maps found in Trash', 'advance-image-mapping' ),
			'menu_name'          => __( 'Image Maps', 'advance-image-mapping' ),
		);

		$args = array(
			'labels'          => $labels,
			'public'          => false,
			'show_ui'         => true,
			'show_in_menu'    => true,
			'menu_position'   => 20,
			'menu_icon'       => 'dashicons-location-alt',
			'supports'        => array( 'title' ),
			'has_archive'     => false,
			'rewrite'         => false,
			'show_in_rest'    => true, // Enable Gutenberg REST support
			'capability_type' => 'post',
		);

		register_post_type( 'advaimma_image_map', $args );
	}
}
