(function ($) {
	'use strict';

	// For each map wrapper
	$('.advaimma-wrap').each(function () {
		var $wrap = $(this);

		// Delegated click handler for "click" trigger points
		$wrap.on('click.advaimma', '.advaimma-point', function (e) {
			var $point = $(this);
			var trigger = $point.attr('data-trigger') || 'hover';

			if (trigger === 'click') {
				e.stopPropagation();

				// Close any other open points within this wrap
				$wrap.find('.advaimma-point.is-open').not($point).removeClass('is-open');

				// Toggle current point
				$point.toggleClass('is-open');
			}
		});

		// Hover handlers for "hover" trigger points
		$wrap.on('mouseenter.advaimma', '.advaimma-point[data-trigger="hover"]', function () {
			$(this).addClass('is-open');
		}).on('mouseleave.advaimma', '.advaimma-point[data-trigger="hover"]', function () {
			$(this).removeClass('is-open');
		});

		// Close when clicking outside (only for click-mode points)
		$(document).on('click.advaimmaOutside', function (e) {
			if ($wrap.has(e.target).length === 0) {
				$wrap.find('.advaimma-point.is-open').removeClass('is-open');
			}
		});
	});
})(jQuery);
