<?php
/**
 * Plugin Name:     Advance Image Mapping
 * Plugin URI:      https://wordpress.org/plugins/advance-image-mapping/
 * Description:     Create interactive image mappings with custom icons and tooltips.
 * Version:         1.2.0
 * Author:          Ayush Guleria
 * Author URI:      https://profiles.wordpress.org/guleriaharbour/
 * License:         GPL v2 or later
 * License URI:     https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:     advance-image-mapping
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// Plugin constants
define( 'ADVAIMMA_VERSION', '1.2.0' );
define( 'ADVAIMMA_FILE', __FILE__ );
define( 'ADVAIMMA_PATH', plugin_dir_path( __FILE__ ) );
define( 'ADVAIMMA_URL', plugin_dir_url( __FILE__ ) );

// Load required files
require_once ADVAIMMA_PATH . 'includes/class-cpt.php';
require_once ADVAIMMA_PATH . 'includes/helpers.php';
require_once ADVAIMMA_PATH . 'includes/class-frontend.php';
require_once ADVAIMMA_PATH . 'includes/class-admin.php';

/**
 * Register Custom Post Type on init
 */
function advaimma_init() {
	if ( class_exists( 'ADVAIMMA_CPT' ) ) {
		ADVAIMMA_CPT::register_post_type();
	}
}
add_action( 'init', 'advaimma_init' );

/**
 * Initialize Frontend or Admin handlers
 */
function advaimma_plugins_loaded() {
	if ( is_admin() ) {
		if ( class_exists( 'ADVAIMMA_Admin' ) ) {
			new ADVAIMMA_Admin();
		}
	} else {
		if ( class_exists( 'ADVAIMMA_Frontend' ) ) {
			new ADVAIMMA_Frontend();
		}
	}
}
add_action( 'plugins_loaded', 'advaimma_plugins_loaded' );

/**
 * Plugin activation: register CPT then flush rewrite rules
 */
function advaimma_activate() {
	advaimma_init();
	flush_rewrite_rules();
}
register_activation_hook( ADVAIMMA_FILE, 'advaimma_activate' );

/**
 * Plugin deactivation: flush rewrite rules
 */
function advaimma_deactivate() {
	flush_rewrite_rules();
}
register_deactivation_hook( ADVAIMMA_FILE, 'advaimma_deactivate' );
