<?php
/**
 * Uninstall cleanup for Admin Maintenance Message
 */
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

/**
 * Option keys to remove (old + new for migration safety).
 * Filter allows extensions in the future.
 */
$keys = apply_filters(
	'ammsg_uninstall_option_keys',
	array( 'ammsg_options', 'ck_admin_maintenance_opts' )
);

/**
 * Delete given options on the current blog.
 */
$delete_options = static function( array $opt_keys ): void {
	foreach ( $opt_keys as $key ) {
		delete_option( $key );
	}
};

if ( is_multisite() ) {
	// Get only IDs to keep memory low on large networks.
	$site_ids = get_sites( array( 'fields' => 'ids', 'number' => 0 ) );

	if ( ! empty( $site_ids ) && is_array( $site_ids ) ) {
		$original = get_current_blog_id();

		foreach ( $site_ids as $blog_id ) {
			switch_to_blog( (int) $blog_id );
			try {
				$delete_options( $keys );
			} finally {
				restore_current_blog(); // ensure we always restore
			}
		}

		// Make sure we’re back on the original blog (paranoia).
		switch_to_blog( (int) $original );
		restore_current_blog();
	}
} else {
	// Single site.
	$delete_options( $keys );
}