(function () {
  if (!window.AMMSG || !window.AMMSG.to) return;

  var targetText = window.AMMSG.to; // "dd.mm.yyyy HH:MM"
  var cdWrap = document.querySelector('.ammsg-countdown');
  if (!cdWrap) return;

  // Versuche das Datum robust zu parsen (de-DE Format dd.mm.yyyy HH:MM)
  var parts = targetText.match(/^(\d{2})\.(\d{2})\.(\d{4})\s+(\d{2}):(\d{2})$/);
  if (!parts) return;

  var d = new Date(
    parseInt(parts[3], 10),          // yyyy
    parseInt(parts[2], 10) - 1,      // mm (0-based)
    parseInt(parts[1], 10),          // dd
    parseInt(parts[4], 10),          // HH
    parseInt(parts[5], 10),          // MM
    0
  );

  function update() {
    var now = new Date().getTime();
    var diff = d.getTime() - now;
    if (diff <= 0) {
      cdWrap.classList.add('d-none');
      return;
    }
    var sec = Math.floor(diff / 1000);
    var days = Math.floor(sec / 86400); sec -= days * 86400;
    var hrs  = Math.floor(sec / 3600);  sec -= hrs * 3600;
    var mins = Math.floor(sec / 60);    sec -= mins * 60;

    var set = function(cls, val){ var el = cdWrap.querySelector('.' + cls); if (el) el.textContent = String(val); };
    set('ammsg-cd-d', days);
    set('ammsg-cd-h', hrs);
    set('ammsg-cd-m', mins);
    set('ammsg-cd-s', sec);

    cdWrap.classList.remove('d-none');
  }

  update();
  setInterval(update, 1000);
})();