<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
?>
<form id="<?php echo esc_attr($id); ?>" method="post" class="woocommerce-form woocommerce-form-address woocommerce-EditAccountForm edit-account">
    <?php wp_nonce_field('save_address', 'save_address_nonce');
    ?>

    <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
        <input type="hidden" name="address_id" class="input-text" required />
    </p>
    <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
        <label for="Address Type"><?php esc_html_e('Address Types', 'addweb-woo-multi-address'); ?>: <span class="required" aria-hidden="true">*</span></label>
        <select name="address_type" class="input-select" required>
            <option value=""><?php echo esc_attr('Select Address Type'); ?></option>
            <option value="billing"><?php echo esc_attr('Billing'); ?></option>
            <option value="shipping" selected><?php echo esc_attr('Shipping'); ?></option>
        </select>
    </p>
    <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
        <label for="address_label"><?php esc_html_e('Address Label', 'addweb-woo-multi-address'); ?>: <span class="required" aria-hidden="true">*</span></label>
        <input type="text" name="address_label" class="input-text" required />
    </p>


    <p class="woocommerce-form-row woocommerce-form-row--first form-row form-row-first">
        <label for="first_name"><?php esc_html_e('First Name', 'addweb-woo-multi-address'); ?>: <span class="required" aria-hidden="true">*</span></label>
        <input type="text" name="first_name" class="input-text" required />
    </p>

    <p class="woocommerce-form-row woocommerce-form-row--last form-row form-row-last">
        <label for="last_name"><?php esc_html_e('Last Name', 'addweb-woo-multi-address'); ?>: <span class="required" aria-hidden="true">*</span></label>
        <input type="text" name="last_name" class="input-text" required />
    </p>
    <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
        <label for="phone"><?php esc_html_e('Phone', 'addweb-woo-multi-address'); ?>: <span class="required" aria-hidden="true">*</span></label>
        <input type="number" name="phone" class="input-text" required />
    </p>

    <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
        <label for="email"><?php esc_html_e('Email', 'addweb-woo-multi-address'); ?>: <span class="required" aria-hidden="true">*</span></label>
        <input type="email" name="email" class="input-text" required />
    </p>


    <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
        <label for="company"><?php esc_html_e('Company', 'addweb-woo-multi-address'); ?>:</label>
        <input type="text" name="company" class="input-text" />
    </p>


    <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide address-field update_totals_on_change">
        <?php
        $field = woocommerce_form_field(
            'billing_country',
            array(
                'type'        => 'country',
                'label'       => __('Country:', 'addweb-woo-multi-address'),
                'required'    => true,
                'class'       => array('form-row-wide', 'address-field', 'update_totals_on_change'),
                'autocomplete' => 'country',
            ),
            WC()->customer ? WC()->customer->get_billing_country() : ''
        );

        if (! empty($field)) {
            echo wp_kses_post($field);
        }
        ?>
    </p>

    <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide address-field">
        <?php
        $field = woocommerce_form_field(
            'billing_state',
            array(
                'type'        => 'state',
                'label'       => __('State:', 'addweb-woo-multi-address'),
                'required'    => true,
                'class'       => array('form-row-wide', 'address-field'),
                'autocomplete' => 'address-level1',
            ),
            WC()->customer ? WC()->customer->get_billing_state() : ''
        );

        if (! empty($field)) {
            echo wp_kses_post($field);
        }

        ?>
    </p>



    <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
        <label for="address_1"><?php esc_html_e('Address Line 1', 'addweb-woo-multi-address'); ?>: <span class="required" aria-hidden="true">*</span></label>
        <input type="text" name="address_1" class="input-text" required />
    </p>

    <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
        <label for="address_2"><?php esc_html_e('Address Line 2', 'addweb-woo-multi-address'); ?>:</label>
        <input type="text" name="address_2" class="input-text" />
    </p>
    <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
        <label for="city"><?php esc_html_e('City', 'addweb-woo-multi-address'); ?>: <span class="required" aria-hidden="true">*</span></label>
        <input type="text" name="city" class="input-text" required />
    </p>

    <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
        <label for="postcode"><?php esc_html_e('Postcode', 'addweb-woo-multi-address'); ?>: <span class="required" aria-hidden="true">*</span></label>
        <input type="text" name="postcode" class="input-text" required />
    </p>


    <p>
        <input type="submit" class="woocommerce-Button button save-address-btn" value="<?php esc_html_e('Save Address', 'addweb-woo-multi-address'); ?>" />
        <input type="button" class="woocommerce-Button button cancle cancle_action" value="<?php esc_html_e('cancel', 'addweb-woo-multi-address'); ?>" />
    </p>
</form>