jQuery(document).ready(function ($) {
  
    function setReactInputValue($input, value) {
        const nativeInputValueSetter = Object.getOwnPropertyDescriptor(
            window.HTMLInputElement.prototype,
            'value'
        ).set;
        nativeInputValueSetter.call($input[0], value);
    
        const event = new Event('input', { bubbles: true });
        $input[0].dispatchEvent(event);
    }
    
// Wait for page load
setTimeout(function () {
    toggleBillingSelect();   
    var addressid = jQuery('#contact-namespace-billing_address').val();
    var addressType = jQuery('#contact-namespace-billing_address').attr('id');
    
    addwwomu_onload_checkout_set_address(addressid, addressType);
    var addressid = jQuery('#contact-namespace-shipping_address').val();
    var addressType =  jQuery('#contact-namespace-shipping_address').attr('id');
    addwwomu_onload_checkout_set_address(addressid, addressType);
}, 500);

// Bind change/click events dynamically
    $(document).on('change click', '[id^="checkbox-control-"]', function () {
        let isChecked = $(this).is(':checked');
        let useSameValue = isChecked ? 1 : 0;
        const $field = $('#contact-namespace-use-same');
        if ($field.length) {
            setReactInputValue($field, useSameValue);
        }
    
              
    toggleBillingSelect();
}).trigger('change'); // Force trigger once
$('#contact-namespace-use-same')
.hide()
.addClass('dnone');
    function toggleBillingSelect() {
    
    // Dynamically find the checkbox by ID pattern
    var $checkbox = $('[id^="checkbox-control-"]').first(); // In case multiple, pick first
    var isChecked = $checkbox.is(':checked');
    var $bill = null;
        let useSameValue = isChecked ? 1 : 0;
        const $field = $('#contact-namespace-use-same');
        if ($field.length) {
            setReactInputValue($field, useSameValue);
        }
    if (isChecked) {
        $bill=$('#contact-namespace-billing_address').val('').trigger('change');

        var $bill = $('#contact-namespace-billing_address').val();
        $('.wc-block-components-select-input-namespace-billing_address')
           .hide()
        .addClass('dnone');

           
        //console.log('Checked: Use same address',  $bill);   
    } else {
        $('.wc-block-components-select-input-namespace-billing_address')
            .show()
            .removeClass('dnone');

        var $bill = $('#contact-namespace-billing_address').val();
       // console.log('Unchecked: Different address', $bill);
    }
}


    // Toggle the address form visibility when the "Add New Address" button is clicked
    $('.add-address').on('click', function (e) {
        e.preventDefault();
        jQuery('#addwwomu_show_address').toggleClass('display-show');  // Toggle the "display-none" class
        console.log('');
    });

    $(".cancle_action").on('click', function (e) {
        $("#addwwomu_show_address").removeClass('display-show');
        $("#edit-address-modal").css('display', 'none');
        $("#add_new_address_btn").css('display', 'block');
    })
    // Handle add address form submission
    $('#add-address').on('submit', function (e) {
        e.preventDefault();

        let valid = true;
        let errorMessages = [];

        let requiredFields = [
            'address_type', 'address_label', 'first_name', 'last_name',
            'billing_country', 'billing_state', 'address_1', 'city',
            'postcode', 'phone'
        ];

        // Get form and create FormData instance
        const form = this;
        const formData = new FormData(form);

        // Validate required fields using FormData.get()
        requiredFields.forEach(function(fieldName) {
            const value = formData.get(fieldName);
            const input = form.querySelector('[name="' + fieldName + '"]');

            if (!value || value.trim() === '') {
                valid = false;
                if (input) input.style.borderColor = 'red';
            } else {
                if (input) input.style.borderColor = '';
            }
        });

        if (!valid) {
            alert('Please fill all required fields.');
            return;
        }

        // Additional validation for phone and postcode
        const phoneVal = formData.get('phone') || '';
        const postcodeVal = formData.get('postcode') || '';

        if (!/^\d{5,10}$/.test(postcodeVal)) {
            valid = false;
            errorMessages.push('Postcode must be at least 5 digits.');
            const postcodeInput = form.querySelector('[name="postcode"]');
            if (postcodeInput) postcodeInput.style.borderColor = 'red';
        }

        if (!/^\d{6,12}$/.test(phoneVal)) {
            valid = false;
            errorMessages.push('Invalid phone number.');
            const phoneInput = form.querySelector('[name="phone"]');
            if (phoneInput) phoneInput.style.borderColor = 'red';
        }

        // Email format validation (simple regex)
        const emailInput = form.querySelector('[name="email"]');
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        const emailVal = formData.get('email') || '';

        if (emailVal && !emailRegex.test(emailVal)) {
            valid = false;
            errorMessages.push('Invalid email format.');
            if (emailInput) emailInput.style.borderColor = 'red';
        }

        if (!valid) {
            alert(errorMessages.join('\n'));
            return;
        }


        var data = {
            action: 'addwwomu_add_address',
            operation: 'add',
            address_type: $('select[name="address_type"]').val(),
            address_label: $('input[name="address_label"]').val(),
            first_name: $('input[name="first_name"]').val(),
            last_name: $('input[name="last_name"]').val(),
            company: $('input[name="company"]').val(),
            country: $('select[name="billing_country"]').val(),
            address_1: $('input[name="address_1"]').val(),
            address_2: $('input[name="address_2"]').val(),
            city: $('input[name="city"]').val(),
            state: $('select[name="billing_state"]').val(),
            postcode: $('input[name="postcode"]').val(),
            phone: $('input[name="phone"]').val(),
            email: $('input[name="email"]').val(),
            nonce: addwwomu_multiple_addresses.nonce // Add nonce to the data
        };

        $.post(addwwomu_multiple_addresses.ajax_url, data, function (response) {
            if (response.success) {
                alert(response.data.message);
                location.reload(); // Reload the page to show the new address
            } else {
                alert(response.data.message);
            }
        });
    });


    // Handle delete address action
    // Delete address event handler
    $('.delete-address').on('click', function (e) {
        e.preventDefault();

        // Get the address ID from the data attribute
        var addressId = $(this).data('id');

        // Confirm deletion
        if (!confirm('Are you sure you want to delete this address?')) {
            return;
        }

        // Send AJAX request to delete the address
        $.ajax({
            url: addwwomu_multiple_addresses.ajax_url,
            method: 'POST',
            data: {
                action: 'addwwomu_delete_address',
                nonce: addwwomu_multiple_addresses.nonce,
                address_id: addressId,
            },
            success: function (response) {
                if (response.success) {
                    alert(response.data.message);
                    location.reload(); // Reload the page to update the address list
                } else {
                    alert(response.data.message);
                }
            },
            error: function () {
                alert('An error occurred while deleting the address.');
            }
        });
    });

    // Handle Edit Address action
    $('.edit-address').on('click', function (e) {
        e.preventDefault();
        jQuery('#add_new_address_btn').css('display', 'none');
        jQuery("#addwwomu_show_address").removeClass('display-show').fadeOut(2000);
        var addressId = $(this).data('id');

        // Fetch existing address details (optional: pre-fill form)
        $.ajax({
            url: addwwomu_multiple_addresses.ajax_url,
            method: 'POST',
            data: {
                action: 'addwwomu_get_address_with_id',
                nonce: addwwomu_multiple_addresses.nonce,
                address_id: addressId,
                operation: 'edit'
            },
            success: function (response) {
                if (response.success) {
                    // Populate the form with existing address data
                    var form = $('#edit-address-form');
                    var data = response.data;


                    form.find('[name="address_label"]').val(data.address_label);
                    form.find('[name="address_type"]').val(data.address_type)
                    form.find('[name="first_name"]').val(data.first_name);
                    form.find('[name="last_name"]').val(data.last_name);
                    form.find('[name="company"]').val(data.company);
                    form.find('[name="address_1"]').val(data.address_1);
                    form.find('[name="address_2"]').val(data.address_2);
                    form.find('[name="city"]').val(data.city);
                    form.find('[name="billing_state"]').val(data.state);
                    form.find('[name="postcode"]').val(data.postcode);
                    form.find('[name="billing_country"]').val(data.country);
                    form.find('[name="phone"]').val(data.phone);
                    form.find('[name="email"]').val(data.email);
                    form.find('[name="address_id"]').val(data.id);



                    // Show the form
                    $('#edit-address-modal').fadeIn();
                } else {
                    alert(response.data.message);

                }

            },
            error: function () {
                alert('Failed to fetch address details.');
            }
        });
    });

    // Handle form submission
    $('#edit-address-form').on('submit', function (e) {
        e.preventDefault();
        
        let valid = true;
        let errorMessages = [];

        let requiredFields = [
            'address_type', 'address_label', 'first_name', 'last_name',
            'billing_country', 'billing_state', 'address_1', 'city',
            'postcode', 'phone', 'email'
        ];

        // Get form and create FormData instance
        const form = this;
        const formData = new FormData(form);
       
        // Validate required fields using FormData.get()
        requiredFields.forEach(function(fieldName) {
            const value = formData.get(fieldName);
            const input = form.querySelector('[name="' + fieldName + '"]');

            if (!value || value.trim() === '') {
                valid = false;
                if (input) input.style.borderColor = 'red';
            } else {
                if (input) input.style.borderColor = '';
            }
        });


        if (!valid) {
            alert('Please fill all required fields.');
            return;
        }

        // Email format validation (simple regex)
        const emailInput = form.querySelector('[name="email"]');
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        const emailVal = formData.get('email') || '';

        if (emailVal && !emailRegex.test(emailVal)) {
            valid = false;
            errorMessages.push('Invalid email format111.');
            if (emailInput) emailInput.style.borderColor = 'red';
        }

        // Additional validation for phone and postcode
        const phoneVal = formData.get('phone') || '';
        const postcodeVal = formData.get('postcode') || '';

        if (!/^\d{5,10}$/.test(postcodeVal)) {
            valid = false;
            errorMessages.push('Postcode must be at least 5 digits.');
            const postcodeInput = form.querySelector('[name="postcode"]');
            if (postcodeInput) postcodeInput.style.borderColor = 'red';
        }

        if (!/^\d{6,12}$/.test(phoneVal)) {
            valid = false;
            errorMessages.push('Invalid phone number.');
            const phoneInput = form.querySelector('[name="phone"]');
            if (phoneInput) phoneInput.style.borderColor = 'red';
        }

        if (!valid) {
            alert(errorMessages.join('\n'));
            return;
        }

        // Send AJAX request to save the address
        var formSerialize = $(this).serialize();
        $('.save-address-btn').prop('disabled', true);
        formData.append('action', 'addwwomu_edit_address');
        formData.append('nonce', addwwomu_multiple_addresses.nonce);
    
        // Send AJAX request to save the address
        $.ajax({
                url: addwwomu_multiple_addresses.ajax_url,
                method: 'POST',
                data: formData,
                processData: false, // Prevent jQuery from converting the data
                contentType: false, // Let browser set proper multipart/form-data
            success: function (response) {
                if (response.success) {
                    alert(response.data.message);
                    location.reload(); // Reload the page to reflect changes
                } else {
                    alert(response.data.message);
                }
                jQuery('#add_new_address_btn').removeClass('display-none');
            },
            error: function () {
                alert('Failed to save address.');
            }
        });
    });

    // Set default address event handler
    $('.set-default-address').on('click', function (e) {
        e.preventDefault();

        // Get address ID and type (billing or shipping)
        var addressId = $(this).data('id');
        var addressType = $(this).data('type');

        // Confirm action
        if (!confirm('Set this address as your default ' + addressType + ' address?')) {
            return;
        }

        // Send AJAX request
        $.ajax({
            url: addwwomu_multiple_addresses.ajax_url,
            method: 'POST',
            data: {
                action: 'addwwomu_set_default_address',
                nonce: addwwomu_multiple_addresses.nonce,
                address_id: addressId,
                address_type: addressType
            },
            success: function (response) {
                if (response.success) {
                    alert(response.data.message);
                    location.reload(); // Reload the page to reflect the changes
                } else {
                    alert(response.data.message);
                }
            },
            error: function () {
                alert('An error occurred while updating the default address.');
            }
        });
    });

    // Ensure WooCommerce blocks are loaded before executing
    setTimeout(function () {
        $('.wc-block-components-address-card__edit').each(function () {
            $(this).removeAttr('aria-expanded').attr('aria-expanded', 'true');
        });

        $('.wc-block-components-address-card, .wc-block-components-address-address-wrapper').addClass('is-editing');
    }, 100);


    $(document).on('change', '#contact-namespace-billing_address, #contact-namespace-shipping_address', function () {
        var addressId = $(this).val();
        var addressType = $(this).attr('id');
        var formPrefix = addressType.includes("billing") ? "billing" : "shipping";
        var simple_billing = $('#addwwomu_simple_billing_type').val();
        $('#loader').removeClass('dnone');
        // Step 1: Clear only the selected form fields
        clearCheckoutForm(formPrefix);

        if (!addressId) {
           // console.log("No address selected, form cleared.");
            return;
        }

        // Step 2: Fetch address via AJAX
        $.ajax({
            url: addwwomu_multiple_addresses.ajax_url,
            type: "POST",
            data: {
                action: "addwwomu_get_address_with_id",
                nonce: addwwomu_multiple_addresses.nonce,
                address_id: addressId,

            },
            success: function (response) {
                //console.log("AJAX Response:", response);
                if (response.success) {
                    if (simple_billing) {
                       // console.log("Simple billing address selected.");
                        fillSimpleCheckoutForm(response.data, formPrefix)
                        $('#loader').addClass('dnone');
                     }
                    else { 
                        fillCheckoutForm(response.data, formPrefix);
                    }
                    
                } else {
                    alert("Failed to fetch address: " + response.data.message);
                }
            },
            complete: function () {
                $('#loading-image').hide();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                //console.log("AJAX Error:", textStatus, errorThrown);
                alert("Error fetching address.");
            }
        });
    });

     function addwwomu_onload_checkout_set_address (addressid, addressType) {
        
        // var addressId = $(this).val();
         // var addressType = $(this).attr('id');
         var addressId = addressid;
         var addressType = addressType;
         if (addressType == undefined || addressType == null || addressType == '') {
             return;
         }
        var formPrefix = addressType.includes("billing") ? "billing" : "shipping";
        var simple_billing = $('#addwwomu_simple_billing_type').val();
        $('#loader').removeClass('dnone');
        // Step 1: Clear only the selected form fields
        clearCheckoutForm(formPrefix);

        if (!addressId) {
           // console.log("No address selected, form cleared.");
            return;
        }

        // Step 2: Fetch address via AJAX
        $.ajax({
            url: addwwomu_multiple_addresses.ajax_url,
            type: "POST",
            data: {
                action: "addwwomu_get_address_with_id",
                nonce: addwwomu_multiple_addresses.nonce,
                address_id: addressId,

            },
            success: function (response) {
               // console.log("AJAX Response:", response);
                if (response.success) {
                    if (simple_billing) {
                        //console.log("Simple billing address selected.");
                        fillSimpleCheckoutForm(response.data, formPrefix)
                        $('#loader').addClass('dnone');
                     }
                    else { 
                        fillCheckoutForm(response.data, formPrefix);
                    }
                    
                } else {
                    alert("Failed to fetch address: " + response.data.message);
                }
            },
            complete: function () {
                $('#loading-image').hide();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                //console.log("AJAX Error:", textStatus, errorThrown);
                alert("Error fetching address.");
            }
        });
    }
    function clearCheckoutForm(formPrefix) {
        // Clear input fields
        $(`.wc-block-checkout__form input[id^="${formPrefix}-"]`).each(function () {
            $(this)
                .val('') // Clear input
                .attr('value', '') // Remove default value
                .removeAttr('data-address-filled') // Clear custom attributes
                .trigger('input')
                .trigger('change');
        });

        // Clear select fields (e.g., country/state)
        $(`.wc-block-checkout__form select[id^="${formPrefix}-"]`).each(function () {
            $(this)
                .val('') // Clear selection
                .removeAttr('data-address-filled') // Optional cleanup
                .trigger('change')
                .trigger('blur')
                .trigger('focusout');
        });

        $(`.woocommerce-billing-fields__field-wrapper[id^="${formPrefix}-"]`).each(function () {
           // console.log('Clearing field wrapper:', $(this));
            $(this)
                .val('') // Clear input
                .attr('value', '') // Remove default value
                .removeAttr('data-address-filled') // Clear custom attributes
                .trigger('input')
                .trigger('change');
        });

        // Let WooCommerce recalculate things
        $('body').trigger('update_checkout');
    }


    function fillCheckoutForm(data, formPrefix) {
        //console.log('Filling data for:', formPrefix);

        var fieldMapping = {
            'first_name': `${formPrefix}-first_name`,
            'last_name': `${formPrefix}-last_name`,
            'company': `${formPrefix}-company`,
            'address_1': `${formPrefix}-address_1`,
            'address_2': `${formPrefix}-address_2`,
            'city': `${formPrefix}-city`,
            'postcode': `${formPrefix}-postcode`,
            'phone': `${formPrefix}-phone`,
            'state': `${formPrefix}-state`,
            'country': `${formPrefix}-country`,
            // 'email': `email`
        };

        const selectFields = [];
        let lastInputFieldId = '';
        let lastInputValue = '';

        function waitForField(id, callback) {
            let check = setInterval(() => {
                let $el = $('#' + id);
                if ($el.length) {
                    clearInterval(check);
                    callback($el);
                }
            }, 100);
        }

        function simulateTyping($field, text, doneCallback, index = 0) {
            if (index < text.length) {
                const char = text[index];

                const nativeInputValueSetter = Object.getOwnPropertyDescriptor(
                    Object.getPrototypeOf($field[0]), "value"
                ).set;

                if (nativeInputValueSetter) {
                    nativeInputValueSetter.call($field[0], $field.val() + char);
                } else {
                    $field.val($field.val() + char);
                }

                const eventOptions = { bubbles: true, cancelable: true, key: char };
                $field[0].dispatchEvent(new KeyboardEvent("keydown", eventOptions));
                $field[0].dispatchEvent(new KeyboardEvent("keypress", eventOptions));
                $field[0].dispatchEvent(new InputEvent("input", { bubbles: true }));
                $field[0].dispatchEvent(new KeyboardEvent("keyup", eventOptions));

                setTimeout(() => simulateTyping($field, text, doneCallback, index + 1), 100);
            } else {
                $field.trigger('change').trigger('focusout');
                if (typeof doneCallback === 'function') doneCallback();
            }
        }

        function simulateSelect($field, value, maxAttempts = 5, delay = 100) {
            if (!$field.length || !$field.is('select')) return;

            let attempt = 0;

            const trySelect = () => {
                const el = $field[0];
                const option = $field.find(`option[value="${value}"]`);

                if (!option.length) {
                    console.warn(`❌ Option "${value}" not found in select #${$field.attr('id')}`);
                    return;
                }

                const nativeSetter = Object.getOwnPropertyDescriptor(window.HTMLSelectElement.prototype, 'value').set;
                nativeSetter.call(el, value);

                el.dispatchEvent(new Event('input', { bubbles: true }));
                el.dispatchEvent(new Event('change', { bubbles: true }));
                el.dispatchEvent(new KeyboardEvent('keydown', { key: 'Enter', keyCode: 13, which: 13, bubbles: true }));
                el.dispatchEvent(new KeyboardEvent('keyup', { key: 'Enter', keyCode: 13, which: 13, bubbles: true }));
                el.dispatchEvent(new Event('blur', { bubbles: true }));
                el.dispatchEvent(new Event('focusout', { bubbles: true }));

                $('body').trigger('update_checkout');

                setTimeout(() => {
                    if ($field.val() !== value && attempt < maxAttempts) {
                        attempt++;
                        console.warn(`🔁 Retry ${attempt}: value reset, re-setting...`);
                        trySelect();
                    } else {
                        //console.log(`✅ Simulated select successful: #${$field.attr('id')} = ${$field.val()}`);
                    }
                }, delay + 100);
            };

            trySelect();
        }

        // Loop through fields
        $.each(fieldMapping, function (key, id) {
            let value = data[key] || '';

            if (key === 'postcode') {
                lastInputFieldId = id;
                lastInputValue = value;
            }

            waitForField(id, function ($field) {
                if ($field.is('input')) {
                    $field.val('').trigger('input');
                    simulateTyping($field, value);
                } else if ($field.is('select')) {
                    selectFields.push({ $field, value });
                }
            });
        });

        // Process selects after inputs
        setTimeout(() => {
            selectFields.forEach(({ $field, value }) => {
                simulateSelect($field, value);
            });

            // 🔁 Re-type the last input (e.g., postcode) after WooCommerce AJAX settles
            if (lastInputFieldId && lastInputValue) {
                waitForField(lastInputFieldId, function ($field) {
                    setTimeout(() => {
                        //console.log('🔁 Retyping ZIP/postcode to ensure value is kept');
                        $field.val('').trigger('input');
                        simulateTyping($field, lastInputValue);
                    }, 1500); // Give AJAX time to finish
                });
            }
        }, 1000); // Wait for input typing to finish

        $('body').trigger('update_checkout');

        // Ensure "Ship to different address" is checked if needed
        if (formPrefix === 'shipping') {
            $('input[name="ship_to_different_address"]').prop('checked', true).trigger('change');
        }
    }
    function fillSimpleCheckoutForm(data, formPrefix) {

       // console.log('Simple filling data for:', formPrefix);

    const fieldMapping = {
        'first_name': `${formPrefix}_first_name`,
        'last_name': `${formPrefix}_last_name`,
        'company': `${formPrefix}_company`,
        'address_1': `${formPrefix}_address_1`,
        'address_2': `${formPrefix}_address_2`,
        'city': `${formPrefix}_city`,
        'postcode': `${formPrefix}_postcode`,
        'phone': `${formPrefix}_phone`,
        'state': `${formPrefix}_state`,
        'country': `${formPrefix}_country`,
        // 'email': `email`
    };

    $.each(fieldMapping, function (key, id) {
        const value = data[key] || '';
        const $field = $('#' + id);

        if ($field.length) {
            $field.val(value).trigger('change');
        }
    });

    // Optional: Trigger update_checkout in case WooCommerce needs to refresh
    setTimeout(() => {
        $('body').trigger('update_checkout');
    }, 500);

    }

    //address datatable from address tab in myaccount

    $('#my-address-table').DataTable({
        responsive: true,
        pageLength: 10

    });
 
});
