document.addEventListener("DOMContentLoaded", function () {
    function waitForField(selector, callback) {
        let checkExist = setInterval(() => {
            let field = document.querySelector(selector);
            if (field) {
                clearInterval(checkExist);
                callback(field);
            }
        }, 500); // Check every 500ms
    }

    function syncFieldValue(fieldId, storageKey) {
        waitForField(fieldId, (field) => {
            // Set initial value from sessionStorage
            if (sessionStorage.getItem(storageKey)) {
                field.value = sessionStorage.getItem(storageKey);
            }

            // Listen for user changes
            field.addEventListener("input", function () {
                sessionStorage.setItem(storageKey, this.value);
            });
        });
    }

    // Apply for Billing & Shipping Address Fields
    syncFieldValue("#shipping-address_1", "shippingAddress");
    syncFieldValue("#billing-address_1", "billingAddress");
});
wp.hooks.addFilter(
    'experimental_woocommerce_blocks_checkout_update_order_meta',
    'addweb/custom-checkout-fields',
    function (orderMeta) {
        let shippingField = document.querySelector('#shipping-address_1');
        let billingField = document.querySelector('#billing-address_1');

        if (shippingField && shippingField.value) {
            orderMeta.shipping_address_1 = shippingField.value;
        }

        if (billingField && billingField.value) {
            orderMeta.billing_address_1 = billingField.value;
        }

        return orderMeta;
    }
);

