jQuery(document).ready(function ($) {
    let offset = 0;

    $('#start-import').on('click', function () {
        $('#import-status').html('Starting import...');
        importAddresses();
    });

    $('#export-csv').on('click', function () {
        window.location.href = addwwomu_address_import.ajax_url + '?action=addwwomu_export_addresses_csv';
    });

    function importAddresses() {
        $.post(addwwomu_address_import.ajax_url, {
            action: 'addwwomu_import_addresses',
            nonce: addwwomu_address_import.nonce,
            offset: offset,
        })
            .done(function (response) {
                if (response.success) {
                    const progress = response.data.progress;
                    offset = response.data.offset;

                    $('#progress-bar-fill').css('width', progress + '%').text(progress + '%');

                    if (response.data.completed) {
                        $('#import-status').html('Import complete!');
                        $('#start-import').hide();
                        $('#export-csv').show();
                        alert("Default billing and shipping address imported successfully.");
                        loacaion.reload()
                    } else {
                        importAddresses();
                    }
                } else {
                    $('#import-status').html('An error occurred.');
                }
            })
            .fail(function () {
                $('#import-status').html('An error occurred.');
            });
    }
});
