<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Interface for all activity loggers
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    Activity_Monitor_Pro
 * @subpackage Activity_Monitor_Pro/includes/loggers
 */

interface Activity_Logger_Interface
{
    /**
     * Register hooks for the logger
     */
    public function register_hooks();

    /**
     * Log the activity
     *
     * @param array $args Activity arguments
     */
    public function log_activity($args);

    /**
     * Check if the activity can be undone
     *
     * @return bool
     */
    public function can_undo();

    /**
     * Prepare data for undo
     *
     * @param array $args Activity arguments
     * @return array
     */
    public function prepare_undo_data($args);
}
