<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Fired during plugin deactivation
 *
 * @link       https://lovabuild.com/wordpress-plugins/activity-monitor-pro
 * @since      1.0.0
 *
 * @package    Activity_Monitor_Pro
 * @subpackage Activity_Monitor_Pro/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Activity_Monitor_Pro
 * @subpackage Activity_Monitor_Pro/includes
 * @author     Wole Akinloye <lovabuildagency@gmail.com>
 */
class Activity_Monitor_Pro_Deactivator
{

    /**
     * Short Description. (use period)
     *
     * Long Description.
     *
     * @since    1.0.0
     */
    public static function deactivate()
    {
        // Flush rewrite rules if necessary
        flush_rewrite_rules();
    }

}
