<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) {
	exit;
}

/**
 * Fired during plugin activation
 *
 * @link       https://lovabuild.com/wordpress-plugins/activity-monitor-pro
 * @since      1.0.0
 *
 * @package    Activity_Monitor_Pro
 * @subpackage Activity_Monitor_Pro/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Activity_Monitor_Pro
 * @subpackage Activity_Monitor_Pro/includes
 * @author     Wole Akinloye <lovabuildagency@gmail.com>
 */
class Activity_Monitor_Pro_Activator
{

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate()
	{
		global $wpdb;

		$charset_collate = $wpdb->get_charset_collate();

		$table_logs = $wpdb->prefix . 'activitymon_logs';
		$table_undo = $wpdb->prefix . 'activitymon_undo_data';
		$table_restore = $wpdb->prefix . 'activitymon_restore_points';
		$table_notif = $wpdb->prefix . 'activitymon_notifications';
		$table_anomalies = $wpdb->prefix . 'activitymon_anomalies';
		$table_reports = $wpdb->prefix . 'activitymon_reports';

		$sql_logs = "CREATE TABLE $table_logs (
			id bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
			user_id bigint(20) UNSIGNED NOT NULL,
			user_name varchar(255),
			user_email varchar(255),
			action_type varchar(100) NOT NULL,
			object_type varchar(50) NOT NULL,
			object_id bigint(20) UNSIGNED,
			object_name text,
			object_subtype varchar(50),
			description text,
			severity varchar(20) DEFAULT 'info',
			ip_address varchar(45),
			user_agent text,
			is_undoable tinyint(1) DEFAULT 0,
			undo_status varchar(20) DEFAULT 'pending',
			created_at datetime NOT NULL,
			session_id varchar(64),
			metadata longtext,
			PRIMARY KEY  (id),
			KEY idx_user_id (user_id),
			KEY idx_action_type (action_type),
			KEY idx_object_type (object_type),
			KEY idx_created_at (created_at),
			KEY idx_severity (severity),
			KEY idx_session_id (session_id)
		) $charset_collate;";

		$sql_undo = "CREATE TABLE $table_undo (
			id bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
			log_id bigint(20) UNSIGNED NOT NULL,
			previous_state longtext,
			new_state longtext,
			undo_callback varchar(255),
			undo_params longtext,
			dependencies longtext,
			expires_at datetime,
			created_at datetime NOT NULL,
			PRIMARY KEY  (id),
			KEY idx_log_id (log_id),
			KEY idx_expires_at (expires_at)
		) $charset_collate;";

		$sql_restore = "CREATE TABLE $table_restore (
			id bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
			name varchar(255) NOT NULL,
			description text,
			snapshot_data longblob,
			created_by bigint(20) UNSIGNED,
			created_at datetime NOT NULL,
			file_path varchar(500),
			site_url varchar(500),
			wp_version varchar(20),
			plugin_versions longtext,
			theme_info longtext,
			PRIMARY KEY  (id),
			KEY idx_created_at (created_at)
		) $charset_collate;";

		$sql_notif = "CREATE TABLE $table_notif (
			id bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
			user_id bigint(20) UNSIGNED NOT NULL,
			notification_type varchar(50),
			trigger_conditions longtext,
			channel varchar(20) DEFAULT 'email',
			channel_config longtext,
			is_active tinyint(1) DEFAULT 1,
			last_sent_at datetime,
			created_at datetime NOT NULL,
			PRIMARY KEY  (id),
			KEY idx_user_id (user_id)
		) $charset_collate;";

		$sql_anomalies = "CREATE TABLE $table_anomalies (
			id bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
			log_id bigint(20) UNSIGNED,
			anomaly_type varchar(100),
			confidence_score decimal(5,2),
			description text,
			severity varchar(20) DEFAULT 'medium',
			is_reviewed tinyint(1) DEFAULT 0,
			reviewed_by bigint(20) UNSIGNED,
			reviewed_at datetime,
			detected_at datetime NOT NULL,
			PRIMARY KEY  (id),
			KEY idx_detected_at (detected_at),
			KEY idx_severity (severity)
		) $charset_collate;";

		$sql_reports = "CREATE TABLE $table_reports (
			id bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
			report_name varchar(255),
			report_type varchar(50),
			frequency varchar(20) DEFAULT 'weekly',
			recipients longtext,
			filters longtext,
			next_run_at datetime,
			last_run_at datetime,
			is_active tinyint(1) DEFAULT 1,
			created_by bigint(20) UNSIGNED,
			created_at datetime NOT NULL,
			PRIMARY KEY  (id),
			KEY idx_next_run_at (next_run_at)
		) $charset_collate;";

		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		dbDelta($sql_logs);
		dbDelta($sql_undo);
		dbDelta($sql_restore);
		dbDelta($sql_notif);
		dbDelta($sql_anomalies);
		dbDelta($sql_reports);
	}

}
