<?php

/**
 * Admin Menu Class
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    Activity_Monitor_Pro
 * @subpackage Activity_Monitor_Pro/includes/admin
 */

/**
 * Admin Menu Class.
 *
 * Handles the creation of admin menus and submenus.
 *
 * @package    Activity_Monitor_Pro
 * @subpackage Activity_Monitor_Pro/includes/admin
 * @author     Your Name <email@example.com>
 */
class Activity_Monitor_Pro_Menu
{

    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $plugin_name    The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

    /**
     * Initialize the class and set its properties.
     *
     * @since    1.0.0
     * @param      string    $plugin_name       The name of this plugin.
     * @param      string    $version    The version of this plugin.
     */
    public function __construct($plugin_name, $version)
    {

        $this->plugin_name = $plugin_name;
        $this->version = $version;

    }

    /**
     * Register the admin menu.
     *
     * @since    1.0.0
     */
    public function add_plugin_admin_menu()
    {

        add_menu_page(
            'Activity Monitor Pro',
            'Activity Monitor',
            'manage_options',
            $this->plugin_name,
            array($this, 'display_dashboard'),
            'dashicons-chart-area',
            2
        );

        add_submenu_page(
            $this->plugin_name,
            'Dashboard',
            'Dashboard',
            'manage_options',
            $this->plugin_name,
            array($this, 'display_dashboard')
        );

        add_submenu_page(
            $this->plugin_name,
            'Activity Log',
            'Activity Log',
            'manage_options',
            $this->plugin_name . '-log',
            array($this, 'display_log')
        );

        add_submenu_page(
            $this->plugin_name,
            'Settings',
            'Settings',
            'manage_options',
            $this->plugin_name . '-settings',
            array($this, 'display_settings')
        );
    }

    /**
     * Display the settings view.
     *
     * @since    1.0.0
     */
    public function display_settings()
    {
        require_once plugin_dir_path(dirname(dirname(__FILE__))) . 'admin/views/settings.php';
    }

    /**
     * Display the dashboard view.
     *
     * @since    1.0.0
     */
    public function display_dashboard()
    {
        require_once plugin_dir_path(dirname(dirname(__FILE__))) . 'admin/views/dashboard.php';
    }

    /**
     * Display the log view.
     *
     * @since    1.0.0
     */
    public function display_log()
    {
        require_once plugin_dir_path(dirname(dirname(__FILE__))) . 'admin/views/activity-log.php';
    }

}
