<?php
/**
 * Settings View
 *
 * @package Activity_Monitor_Pro
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

// Ensure only admins can access
if (!current_user_can('manage_options')) {
    wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'activity-monitor-pro'));
}

// Save settings if posted
if (isset($_POST['amp_save_settings']) && check_admin_referer('amp_save_settings_nonce', 'amp_nonce')) {
    $activity_monitor_pro_ignored_users = array_map('intval', isset($_POST['amp_ignored_users']) ? $_POST['amp_ignored_users'] : array());
    update_option('activity_monitor_ignored_users', $activity_monitor_pro_ignored_users);

    echo '<div class="notice notice-success is-dismissible"><p>Settings saved successfully.</p></div>';
}

// Get current settings
$activity_monitor_pro_ignored_users = get_option('activity_monitor_ignored_users', array());

// Get all users for selection
$activity_monitor_pro_users = get_users(array('fields' => array('ID', 'user_login', 'display_name')));
?>

<div class="wrap amp-wrap">
    <div class="amp-header">
        <div class="amp-brand">
            <span class="dashicons dashicons-admin-settings amp-logo-icon"></span>
            <div>
                <h1>Settings</h1>
                <span class="amp-meta">
                    Configure Activity Monitor Pro &bull;
                    <a href="https://lovabuild.com/docs/activity-monitor-pro" target="_blank">Documentation</a>
                </span>
            </div>
        </div>
    </div>

    <form method="post" action="">
        <?php wp_nonce_field('amp_save_settings_nonce', 'amp_nonce'); ?>

        <div class="amp-grid">
            <!-- General Settings -->
            <div class="amp-card">
                <h2>General Settings</h2>

                <div style="margin-bottom: 20px;">
                    <label for="amp_retention_days" style="display:block; font-weight:600; margin-bottom:5px;">Log
                        Retention</label>
                    <input type="text" value="30 days" class="amp-select" disabled>
                    <p class="description">Logs older than 30 days are automatically deleted.</p>
                </div>

                <div style="margin-bottom: 20px;">
                    <label for="amp_ignored_users" style="display:block; font-weight:600; margin-bottom:5px;">Ignored
                        Users</label>
                    <select id="amp_ignored_users" name="amp_ignored_users[]" class="amp-select" multiple
                        style="height: 150px;">
                        <?php foreach ($activity_monitor_pro_users as $activity_monitor_pro_user): ?>
                            <option value="<?php echo esc_attr($activity_monitor_pro_user->ID); ?>" <?php selected(in_array($activity_monitor_pro_user->ID, $activity_monitor_pro_ignored_users)); ?>>
                                <?php echo esc_html($activity_monitor_pro_user->display_name . ' (' . $activity_monitor_pro_user->user_login . ')'); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <p class="description">Hold Ctrl/Cmd to select multiple users. Activities from these users will not
                        be logged.</p>
                </div>
            </div>

            <!-- Info Card -->
            <div class="amp-card">
                <h2>Activity Logging</h2>
                <p>The free version logs the following activity types:</p>
                <ul style="list-style: disc; margin-left: 20px; margin-top: 10px;">
                    <li><strong>Posts</strong> - Create, update, delete, publish, trash</li>
                    <li><strong>Pages</strong> - Create, update, delete, publish, trash</li>
                    <li><strong>Media</strong> - Upload, delete, edit</li>
                    <li><strong>Users</strong> - Login, logout, register, profile updates</li>
                </ul>
                <p style="margin-top: 15px;"><strong>Weekly Reports:</strong> Automatic weekly activity summaries sent
                    to admin email.</p>
                <p style="margin-top: 10px;"><strong>Undo:</strong> Undo capabilities for posts and pages.</p>
            </div>
        </div>

        <div style="margin-top: 20px;">
            <button type="submit" name="amp_save_settings" class="amp-btn amp-btn-primary">
                <span class="dashicons dashicons-saved"></span> Save Settings
            </button>
        </div>
    </form>
</div>