<?php
/**
 * Dashboard View
 *
 * @package Activity_Monitor_Pro
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

// Get stats (mock data for now, will implement real stats later)
$activity_monitor_pro_total_activities = Activity_Monitor_Pro_Database::get_total_logs_count();
$activity_monitor_pro_anomalies_count = 0; // Placeholder
$activity_monitor_pro_users_active = 5; // Placeholder
?>

<div class="wrap amp-wrap">
    <!-- Header -->
    <div class="amp-header">
        <div class="amp-brand">
            <span class="dashicons dashicons-shield-alt amp-logo-icon"></span>
            <div>
                <h1>Activity Monitor Pro</h1>
                <span class="amp-meta">
                    v<?php echo esc_html(ACTIVITY_MONITOR_PRO_VERSION); ?> &bull;
                    <a href="https://lovabuild.com" target="_blank" style="color:inherit;text-decoration:none;">By Wole
                        Akinloye</a> &bull;
                    <a href="https://lovabuild.com/wordpress-plugins/activity-monitor-pro" target="_blank">Website</a>
                    &bull;
                    <a href="https://lovabuild.com/docs/activity-monitor-pro" target="_blank">Documentation</a>
                </span>
            </div>
        </div>
        <div class="amp-header-actions">
            <a href="<?php echo esc_url(admin_url('admin.php?page=activity-monitor-pro-settings')); ?>"
                class="amp-btn amp-btn-outline">
                <span class="dashicons dashicons-admin-settings"></span> Settings
            </a>
            <a href="mailto:lovabuildagency@gmail.com" class="amp-btn amp-btn-primary">
                <span class="dashicons dashicons-email-alt"></span> Support
            </a>
        </div>
    </div>

    <!-- Stats Grid -->
    <div class="amp-grid">
        <div class="amp-card amp-stat-card">
            <div class="amp-stat-content">
                <h3>Total Activities</h3>
                <div class="amp-stat-value">
                    <?php echo esc_html(number_format($activity_monitor_pro_total_activities)); ?></div>
            </div>
            <span class="dashicons dashicons-chart-bar amp-stat-icon"></span>
        </div>
        <div class="amp-card amp-stat-card">
            <div class="amp-stat-content">
                <h3>Anomalies Detected</h3>
                <div class="amp-stat-value" style="color: var(--amp-warning);">
                    <?php echo esc_html(number_format($activity_monitor_pro_anomalies_count)); ?>
                </div>
            </div>
            <span class="dashicons dashicons-warning amp-stat-icon" style="color: var(--amp-warning);"></span>
        </div>
        <div class="amp-card amp-stat-card">
            <div class="amp-stat-content">
                <h3>Active Users (24h)</h3>
                <div class="amp-stat-value"><?php echo esc_html(number_format($activity_monitor_pro_users_active)); ?>
                </div>
            </div>
            <span class="dashicons dashicons-admin-users amp-stat-icon"></span>
        </div>
    </div>

    <!-- Activity Feed -->
    <div class="amp-feed-container">
        <div class="amp-feed-header">
            <h2>Recent Activity</h2>
            <div class="amp-feed-actions">
                <button id="amp-refresh-log" class="amp-btn amp-btn-outline amp-btn-sm">
                    <span class="dashicons dashicons-update"></span> Refresh
                </button>
            </div>
        </div>

        <!-- Filters (Hidden by default, toggleable) -->
        <div class="amp-filters">
            <select class="amp-select" id="amp-filter-type">
                <option value="">All Types</option>
                <option value="post">Content</option>
                <option value="user">User</option>
                <option value="system">System</option>
            </select>
            <select class="amp-select" id="amp-filter-user">
                <option value="">All Users</option>
                <!-- Populate via JS or PHP -->
            </select>
        </div>

        <div id="amp-activity-feed" class="amp-activity-list">
            <!-- Content loaded via AJAX -->
            <div style="padding: 40px; text-align: center; color: var(--amp-text-muted);">
                <span class="spinner is-active" style="float: none; margin: 0;"></span> Loading activities...
            </div>
        </div>
    </div>
</div>