<?php
/**
 * Activity Log View
 *
 * @package Activity_Monitor_Pro
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;
?>

<div class="wrap amp-wrap">
    <div class="amp-header">
        <div class="amp-brand">
            <span class="dashicons dashicons-list-view amp-logo-icon"></span>
            <div>
                <h1>Activity Log</h1>
                <span class="amp-meta">
                    Full history of site activities &bull;
                    <a href="https://lovabuild.com/docs/activity-monitor-pro" target="_blank">Documentation</a>
                </span>
            </div>
        </div>
        <div class="amp-header-actions">
            <button id="amp-export-csv" class="amp-btn amp-btn-outline">
                <span class="dashicons dashicons-download"></span> Export CSV
            </button>
        </div>
    </div>

    <div class="amp-feed-container">
        <!-- Advanced Filters -->
        <div class="amp-filters">
            <?php
            // Get users for filter
            $activity_monitor_pro_users = get_users(array('fields' => array('ID', 'display_name')));
            ?>
            <input type="text" id="amp-search-log" class="amp-select" placeholder="Search activities..."
                style="min-width: 250px;">

            <select class="amp-select" id="amp-filter-user">
                <option value="">All Users</option>
                <?php foreach ($activity_monitor_pro_users as $activity_monitor_pro_user): ?>
                    <option value="<?php echo esc_attr($activity_monitor_pro_user->ID); ?>">
                        <?php echo esc_html($activity_monitor_pro_user->display_name); ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <select class="amp-select" id="amp-filter-type">
                <option value="">All Types</option>
                <option value="post">Posts</option>
                <option value="page">Pages</option>
                <option value="user">User</option>
                <option value="system">System</option>
                <option value="plugin">Plugin</option>
                <option value="theme">Theme</option>
            </select>

            <select class="amp-select" id="amp-filter-severity">
                <option value="">All Severities</option>
                <option value="info">Info</option>
                <option value="warning">Warning</option>
                <option value="critical">Critical</option>
            </select>

            <input type="date" id="amp-filter-date-start" class="amp-select">
            <span style="align-self: center; color: var(--amp-text-muted);">to</span>
            <input type="date" id="amp-filter-date-end" class="amp-select">

            <button id="amp-apply-filters" class="amp-btn amp-btn-primary">Apply Filters</button>
            <button id="amp-reset-filters" class="amp-btn amp-btn-outline">Reset</button>
        </div>

        <!-- Log Table/List -->
        <div id="amp-full-log-list" class="amp-activity-list">
            <div style="padding: 40px; text-align: center; color: var(--amp-text-muted);">
                <span class="spinner is-active" style="float: none; margin: 0;"></span> Loading logs...
            </div>
        </div>

        <!-- Pagination -->
        <div class="amp-pagination"
            style="padding: 20px; border-top: 1px solid var(--amp-border); display: flex; justify-content: center; gap: 10px;">
            <button class="amp-btn amp-btn-outline amp-btn-sm" id="amp-prev-page" disabled>&laquo; Previous</button>
            <span id="amp-page-info" style="align-self: center; font-size: 14px; color: var(--amp-text-muted);">Page
                1</span>
            <button class="amp-btn amp-btn-outline amp-btn-sm" id="amp-next-page">Next &raquo;</button>
        </div>
    </div>
</div>