(function ($) {
    'use strict';

    $(document).ready(function () {
        function loadLogs() {
            $.ajax({
                url: activity_monitor_ajax.ajax_url,
                type: 'POST',
                data: {
                    action: 'activity_monitor_get_latest_logs',
                    nonce: activity_monitor_ajax.nonce
                },
                success: function (response) {
                    if (response.success) {
                        $('#amp-activity-feed').html(response.data.html);
                    } else {
                        $('#amp-activity-feed').html('<div style="padding: 20px; text-align: center;">' + response.data + '</div>');
                    }
                }
            });
        }

        // Initial Load
        loadLogs();

        // Refresh Button
        $('#amp-refresh-log').on('click', function () {
            $('#amp-activity-feed').html('<div style="padding: 40px; text-align: center; color: var(--amp-text-muted);"><span class="spinner is-active" style="float: none; margin: 0;"></span> Refreshing...</div>');
            loadLogs();
        });

        // Handle Undo Click
        $(document).off('click', '.amp-undo-btn').on('click', '.amp-undo-btn', function (e) {
            e.preventDefault();
            var btn = $(this);
            var logId = btn.data('id');

            if (confirm('Are you sure you want to undo this action?')) {
                btn.addClass('updating-message');
                $.ajax({
                    url: activity_monitor_ajax.ajax_url,
                    type: 'POST',
                    data: {
                        action: 'activity_monitor_undo',
                        log_id: logId,
                        nonce: activity_monitor_ajax.nonce
                    },
                    success: function (response) {
                        if (response.success) {
                            alert('Action undone successfully!');
                            loadLogs();
                        } else {
                            alert('Error: ' + (response.data || 'Unknown error'));
                        }
                        btn.removeClass('updating-message');
                    },
                    error: function (xhr, status, error) {
                        alert('Request failed: ' + error);
                        btn.removeClass('updating-message');
                    }
                });
            }
        });
    });

})(jQuery);
