(function ($) {
    'use strict';

    $(document).ready(function () {

        // --- Dashboard Logic ---

        // Auto-refresh dashboard feed
        if ($('#amp-activity-feed').length > 0) {
            setInterval(function () {
                // Only refresh if not currently loading
                if (!$('#amp-activity-feed').find('.spinner').length) {
                    // We can trigger the refresh button click to reuse logic
                    // But let's be subtle and just reload content
                    loadDashboardLogs();
                }
            }, 30000);
        }

        function loadDashboardLogs() {
            $.ajax({
                url: activity_monitor_ajax.ajax_url,
                type: 'POST',
                data: {
                    action: 'activity_monitor_get_latest_logs',
                    nonce: activity_monitor_ajax.nonce
                },
                success: function (response) {
                    if (response.success) {
                        $('#amp-activity-feed').html(response.data.html);
                    } else {
                        $('#amp-activity-feed').html('<div class="notice notice-error inline"><p>Error loading logs: ' + (response.data || 'Unknown error') + '</p></div>');
                    }
                },
                error: function (xhr, status, error) {
                    $('#amp-activity-feed').html('<div class="notice notice-error inline"><p>Request failed: ' + error + '</p></div>');
                }
            });
        }

        // --- Undo/Redo Logic ---

        $(document).on('click', '.amp-undo-btn', function (e) {
            e.preventDefault();
            var $button = $(this);
            var logId = $button.data('id');

            if (!confirm('Are you sure you want to undo this action?')) {
                return;
            }

            $button.prop('disabled', true).html('<span class="spinner is-active" style="float:none;margin:0;"></span>');

            $.ajax({
                url: activity_monitor_ajax.ajax_url,
                type: 'POST',
                data: {
                    action: 'activity_monitor_undo',
                    log_id: logId,
                    nonce: activity_monitor_ajax.nonce
                },
                success: function (response) {
                    if (response.success) {
                        alert('Action undone successfully!');
                        // Reload current view
                        if ($('#amp-activity-feed').length) {
                            loadDashboardLogs();
                        } else if ($('#amp-full-log-list').length) {
                            $('#amp-apply-filters').click(); // Reload list
                        } else {
                            location.reload();
                        }
                    } else {
                        alert('Error: ' + response.data);
                        $button.prop('disabled', false).html('<span class="dashicons dashicons-undo"></span> Undo');
                    }
                },
                error: function () {
                    alert('Request failed');
                    $button.prop('disabled', false).html('<span class="dashicons dashicons-undo"></span> Undo');
                }
            });
        });

        $(document).on('click', '.amp-redo-btn', function (e) {
            e.preventDefault();
            var $button = $(this);
            var logId = $button.data('id');

            if (!confirm('Are you sure you want to redo this action?')) {
                return;
            }

            $button.prop('disabled', true).html('<span class="spinner is-active" style="float:none;margin:0;"></span>');

            $.ajax({
                url: activity_monitor_ajax.ajax_url,
                type: 'POST',
                data: {
                    action: 'activity_monitor_redo',
                    log_id: logId,
                    nonce: activity_monitor_ajax.nonce
                },
                success: function (response) {
                    if (response.success) {
                        alert('Action redone successfully!');
                        // Reload current view
                        if ($('#amp-activity-feed').length) {
                            loadDashboardLogs();
                        } else if ($('#amp-full-log-list').length) {
                            $('#amp-apply-filters').click(); // Reload list
                        } else {
                            location.reload();
                        }
                    } else {
                        alert('Error: ' + response.data);
                        $button.prop('disabled', false).html('<span class="dashicons dashicons-redo"></span> Redo');
                    }
                },
                error: function () {
                    alert('Request failed');
                    $button.prop('disabled', false).html('<span class="dashicons dashicons-redo"></span> Redo');
                }
            });
        });

        // --- Export CSV ---
        $('#amp-export-csv').on('click', function (e) {
            e.preventDefault();
            var $btn = $(this);
            $btn.prop('disabled', true).text('Exporting...');

            // Redirect to export URL
            window.location.href = activity_monitor_ajax.ajax_url + '?action=activity_monitor_export_csv&nonce=' + activity_monitor_ajax.nonce;

            setTimeout(function () {
                $btn.prop('disabled', false).html('<span class="dashicons dashicons-download"></span> Export CSV');
            }, 3000);
        });

    });

})(jQuery);
