(function ($) {
    'use strict';

    $(document).ready(function () {
        var currentPage = 1;

        function loadFullLogs(page) {
            var search = $('#amp-search-log').val();
            var user = $('#amp-filter-user').val();
            var type = $('#amp-filter-type').val();
            var severity = $('#amp-filter-severity').val();

            $('#amp-full-log-list').html('<div style="padding: 40px; text-align: center; color: var(--amp-text-muted);"><span class="spinner is-active" style="float: none; margin: 0;"></span> Loading...</div>');

            $.ajax({
                url: activity_monitor_ajax.ajax_url,
                type: 'POST',
                data: {
                    action: 'activity_monitor_get_logs',
                    nonce: activity_monitor_ajax.nonce,
                    page: page,
                    search: search,
                    user_id: user,
                    type: type,
                    severity: severity
                },
                success: function (response) {
                    if (response.success) {
                        $('#amp-full-log-list').html(response.data.html);
                        $('#amp-page-info').text('Page ' + page + ' of ' + response.data.total_pages);

                        $('#amp-prev-page').prop('disabled', page <= 1);
                        $('#amp-next-page').prop('disabled', page >= response.data.total_pages);

                        currentPage = page;
                    } else {
                        $('#amp-full-log-list').html('<div style="padding: 20px; text-align: center;">' + (response.data || 'Error loading logs') + '</div>');
                    }
                },
                error: function (xhr, status, error) {
                    $('#amp-full-log-list').html('<div style="padding: 40px; text-align: center; color: #dc3545;"><span class="dashicons dashicons-warning" style="font-size: 24px;"></span><br><strong>Failed to load activity logs</strong><br><small>' + error + '</small></div>');
                }
            });
        }

        // Initial Load
        loadFullLogs(1);

        // Filters
        $('#amp-apply-filters').on('click', function () {
            loadFullLogs(1);
        });

        $('#amp-reset-filters').on('click', function () {
            $('#amp-search-log').val('');
            $('#amp-filter-user').val('');
            $('#amp-filter-type').val('');
            $('#amp-filter-severity').val('');
            loadFullLogs(1);
        });

        // Pagination
        $('#amp-prev-page').on('click', function () {
            if (currentPage > 1) loadFullLogs(currentPage - 1);
        });

        $('#amp-next-page').on('click', function () {
            loadFullLogs(currentPage + 1);
        });
    });

})(jQuery);
